<?php
# This page will create the company directory service. It has two actions. The first is default which
# will list the employee with extensions, the second lists the specific

# Copyright 2003 by Brandon Tatton and Jared Smith
# Licensed under the GPL

##########################################
# Config section

$Server = "http://10.0.0.3";   # don't add a trailing slash!
$LongDistanceExtension = "81"; # change this to match your config

##########################################
#
# Set content type
header("Content-Type: text/xml");

# This is the include file that establishes the connection to the MySQL database
require ("DBConnect.inc"); 

# This sets the offset for the LIMIT portion of the query
$NextStartingRow = $NextSet*30;

# Connect to the database
$ConnectionSuccess = db_connect();
if (!$ConnectionSuccess) exit;

# If the variable "UserID" is passed in through the GET string, then display 
# extension, phone number and cell phone number for that record with the dial
# key functionality
if ($UserID) {
	$EmployeeDirectoryListing = "<CiscoIPPhoneDirectory>\n"; 
        
	$Query  = "SELECT UserID, FirstName, LastName, Extension, MobilePhoneNumber, ";
	$Query .= "HomePhoneNumber FROM user WHERE Extension IS NOT NULL AND UserID = '$UserID' ";
	$Query .= "ORDER BY LastName";
	
	$SelectEmployeeInfo = mysql_query($Query,$ConnectionSuccess);

	while ($row = mysql_fetch_array($SelectEmployeeInfo)) {
		$CellPhone = ereg_replace("[ ()-]+", "", $row['MobilePhoneNumber']);
		$HomePhone = ereg_replace("[ ()-]+", "", $row['HomePhoneNumber']);

		$EmployeeDirectoryListing .= "<DirectoryEntry>\n";
		$EmployeeDirectoryListing .= "<Name>Extension:</Name>\n";
		$EmployeeDirectoryListing .= "<Telephone>" . $row["Extension"] . "</Telephone>\n";
		$EmployeeDirectoryListing .= "</DirectoryEntry>\n";

		if ($row["MobilePhoneNumber"]) {
			$EmployeeDirectoryListing .= "<DirectoryEntry>\n";
			$EmployeeDirectoryListing .= "<Name>Cell:</Name>\n";
			$EmployeeDirectoryListing .= "<Telephone>$LongDistanceExtension$CellPhone</Telephone>\n";
			$EmployeeDirectoryListing .= "</DirectoryEntry>\n";
		}

		if ($row["HomePhoneNumber"]) {
			$EmployeeDirectoryListing .= "<DirectoryEntry>\n";
			$EmployeeDirectoryListing .= "<Name>Home:</Name>\n";
			$EmployeeDirectoryListing .= "<Telephone>$LongDistanceExtension$HomePhone</Telephone>\n";
			$EmployeeDirectoryListing .= "</DirectoryEntry>\n";
		}
	}
	
	$EmployeeDirectoryListing .= "</CiscoIPPhoneDirectory>\n"; 
	
	echo "$EmployeeDirectoryListing";

# If the variable UserID is not passed in on the GET string, then do the 
# entire company directory, unless LastName is passed in. If so then we 
# will be using a LIKE filter in our SQL query
} else {
	$CompanyNameList = "<CiscoIPPhoneMenu>\n";
	$CompanyNameList .= "<Title>Company Directory</Title>\n";
	$CompanyNameList .= "<Prompt>Please select one</Prompt>\n";

	$Query = "select UserID, FirstName, LastName, Extension, MobilePhoneNumber, ";
	$Query .= "HomePhoneNumber from user where Extension is not NULL and IsActive = 'Y' ";
	
	# If we are searching by last name the add this filter to the query
	if ($LastName) $Query .= "and LastName like '$LastName%' "; 
	$Query .= "order by LastName";

	# If this is the first page of the company directory then we will display the first 30
	if (!$NextSet) {
		$Query .= " Limit 0,30"; 
	# Now for each subsiquent call we get the next 30 records.
	} else {
		$Query .= " Limit $NextStartingRow,30"; 
	}

	# Execute the query
	$SelectNameList = mysql_query($Query,$ConnectionSuccess);
	
	# Count the number of rows returned. This is important because if a full 30 are returned 
	# we will display a more option
	$NumberOfRows = mysql_num_rows($SelectNameList);
	
	if ($NumberOfRows >= 30) {
		$NextSetValue = $NextSet+1;	
	}

	# Parse through the query and set up the menu items.
	while ($row = mysql_fetch_array($SelectNameList)) {
		$CompanyNameList .= "<MenuItem>\n";
			$CompanyNameList .= "<Name>"; 
				$CompanyNameList .= $row["LastName"]; 
				if ($row["FirstName"]) $CompanyNameList .= ", " . $row["FirstName"]; 
			$CompanyNameList .= "</Name>\n";
			$CompanyNameList .= "<URL>";
				$CompanyNameList .= "$Server/companyDirectory.php?";
				$CompanyNameList .= "UserID="; 
				$CompanyNameList .= $row["UserID"]; 
				$CompanyNameList .= "</URL>\n";
		$CompanyNameList .= "</MenuItem>\n";
	}
	
	# If we set NextSetValue above then we will display the more option. Which sets NextSet
	if ($NextSetValue) {
		$CompanyNameList .= "<MenuItem>\n";
			$CompanyNameList .= "<Name>MORE</Name>\n";
			$CompanyNameList .= "<URL>$Server/companyDirectory.php?NextSet=$NextSetValue</URL>\n";
		$CompanyNameList .= "</MenuItem>\n";
	}
	$CompanyNameList .= "</CiscoIPPhoneMenu>";
	echo "$CompanyNameList";
}
?>
