/*
 * Functions Windows doesn't have... but should
 * Copyright(C) 2001, Linux Support Services, Inc.
 *
 * Distributed under GNU LGPL.
 *
 * These are NOT fully compliant with BSD 4.3 and are not
 * threadsafe.
 *
 */

#include <time.h>
#include <winsock2.h>
#include <stdio.h>

time_t	startuptime;

int paircount = 0;

inline int inet_aton(char *cp, struct in_addr *inp)
{
	int res;
	int a1, a2, a3, a4;
	unsigned int saddr;
	if (sscanf(cp, "%d.%d.%d.%d", &a1, &a2, &a3, &a4) != 4)
		return 0;
	a1 &= 0xff;
	a2 &= 0xff;
	a3 &= 0xff;
	a4 &= 0xff;
	saddr = (a1 << 24) | (a2 << 16) | (a3 << 8) | a4;
	inp->s_addr = htonl(saddr);
	return 1;
}

/* Win-doze doenst have gettimeofday(). This sux. So, what we did is
provide some gettimeofday-like functionality that works for our purposes.
In the main(), we take a sample of the system tick counter (into startuptime).
This function returns the relative time since program startup, more or less,
which is certainly good enough for our purposes. */

int gettimeofday(struct timeval *tv, struct timezone *tz)
{
	long l = startuptime + GetTickCount();

	tv->tv_sec = l / 1000;
	tv->tv_usec = (l % 1000) * 1000;
	return 1;
}

void bzero(void *b, size_t len)
{
	memset(b,0,len);
}

