#include <math.h>
#include <string.h>
#include <stdio.h>

#define duration 1200
#define pause 400

float col[] = { 1209.0, 1336.0, 1477.0, 1633.0 };
float row[] = { 697.0, 770.0, 852.0, 941.0 };
char positions[] = "123A456B789C*0#D";

int putval(short val)
{
  static int pos = 0;
  printf("%#06hx, ", val);

}


main(int argc, char *argv[]) {
  int i;
  char *ap, *cp;
  float f1, f2, ri, ci;

  if (argc != 3)
    exit(1);

  printf(
"/* 
 * Signed 16-bit audio data representing '%s' in dtmf
 * 
 * Copyright (C) 2000, Linux Support Services, Inc.
 * 
 * Distributed under the terms of the GNU General
 * Public License
 *
 */

static short %s[] = { 
", argv[1], argv[2]);
  
  ap = argv[1];
  while (*ap) {
    cp = strchr(positions, *ap);
    if (cp) {
      ci = col[(cp - positions) % 4];
      ri = row[(cp - positions) / 4];
      for (f1 = 0.0, f2 = 0.0, i=0; i < duration;
	   i++, f1 += 6.28/8000.0*ri, f2 += 6.28/8000.0*ci) {
	putval((sin(f1)*8191.0) + (sin(f2)*8191.0) + 16384);
      }
      for (i = 0; i < pause; i++)
	putval(16384);
    }
    ap++;
  }
  printf(" };\n");
  return 0;
}
