/*
 * Convert raw signed data into a C array
 */

#include <assert.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>

int main(int argc, char *argv[])
{
	int i;
	int x;
	int res;
	FILE *o;
	char *n;
	short buf[65536 * 2];
	if (argc < 3) {
		printf("Usage: raw2h <input file> <output file>\n");
	}
	i = open(argv[1], O_RDONLY);
	o = fopen(argv[2], "w");
	assert(i >= 0);
	assert((int)o);
	n = strdup(argv[2]);
	strtok(n, ".");
	res = read(i, buf, sizeof(buf));
	assert(res >= 0);
	assert(res < sizeof(buf));
	fprintf(o, 
"/*
  * Signed 16-bit audio data
  *
  * Source: %s
  *
  * Copyright (C) 1999, Mark Spencer and Linux Support Services
  *
  * Distributed under the terms of the GNU General Public License
  *
  */

static signed short %s[] = {
",	argv[1], n);
	for (x=0;x<res/2 - 1;x++) {
		fprintf(o, "%#06hx, ", buf[x]);
		if ((x % 10) == 9)
			fprintf(o, "\n");
	}
	fprintf(o, "%#06hx };\n", buf[x]);
	return 0;
}
