/*
 * Asterisk Tool
 *
 * Andre Bierwirth <bierwirth@kmb.de>
 *
 * Copyright(C) Andre Bierwirth
 *
 * Distributed under the terms of the GNU General Public License (GPL) Version 2
 *
 * Windows Winsock Poll Emulation
 *
 */

#include <winsock2.h>
#include "winpoll.h"


int poll (struct pollfd *fds, unsigned int nfds, int timeout)
{
  int max_fd = 0;
  fd_set *read_fds, *write_fds, *except_fds;
  struct timeval tv;

  tv.tv_sec = timeout / 1000;
  tv.tv_usec = (timeout % 1000) * 1000;

  for (unsigned int i = 0; i < nfds; ++i)
    if (fds[i].fd > max_fd)
      max_fd = fds[i].fd;

  size_t fds_size = nfds * sizeof (fd_set);

  read_fds = (fd_set *) malloc (fds_size);
  write_fds = (fd_set *) malloc (fds_size);
  except_fds = (fd_set *) malloc (fds_size);

  if (!read_fds || !write_fds || !except_fds)
    {
      return -1;
    }

  memset (read_fds, 0, fds_size);
  memset (write_fds, 0, fds_size);
  memset (except_fds, 0, fds_size);

  int invalid_fds = 0;
  for (unsigned int i = 0; i < nfds; ++i)
    {
      fds[i].revents = 0;
	  if (fds[i].events & POLLIN)
	    FD_SET(fds[i].fd, read_fds);
	  if (fds[i].events & POLLOUT)
	    FD_SET(fds[i].fd, write_fds);
	  if (fds[i].events & POLLPRI)
	    FD_SET(fds[i].fd, except_fds);
    }

  int ret = select (max_fd + 1, read_fds, write_fds, except_fds, timeout < 0 ? NULL : &tv);

  if (ret > 0)
    for (unsigned int i = 0; i < nfds; ++i)
    {
	  if (fds[i].fd >= 0)
	  {
		if (FD_ISSET(fds[i].fd, read_fds))
		  fds[i].revents |= POLLIN;
		if (FD_ISSET(fds[i].fd, write_fds))
		  fds[i].revents |= POLLOUT;
		if (FD_ISSET(fds[i].fd, except_fds))
		  fds[i].revents |= POLLPRI;
	  }
    }

  free(read_fds);
  free(write_fds);
  free(except_fds);

  return ret;
}

