/*
 * Asterisk Tool
 *
 * Andre Bierwirth <bierwirth@kmb.de>
 *
 * Copyright(C) Andre Bierwirth
 *
 * Distributed under the terms of the GNU General Public License (GPL) Version 2
 *
 * Windows Local Socket Emulation
 *
 */


#include <windows.h>
#include <malloc.h>
#include "winqueue.h"
#include "phonecore.h"

#define SIMSIZE 50


int sim_buf_push(struct simsock *v, void *data, int size)
{ 	// Buffer Item append
	struct simbuf *newitem,*curitem;
	int cnt = 1;

	newitem = malloc(sizeof(struct simbuf));
	ZeroMemory(newitem,sizeof(struct simbuf));
	newitem->data = malloc(size);
	newitem->size = size;
	CopyMemory(newitem->data, data, size);

//	EnterCriticalSection(&v->lock);
	if (v->queue==NULL) {
		v->queue=newitem;
//		LeaveCriticalSection(&v->lock);
		return cnt;
	}

	curitem = v->queue;

	while (curitem->next) {
		cnt++;
		curitem = curitem->next;
	}
	curitem->next = newitem;
//	LeaveCriticalSection(&v->lock);

	return cnt;
}

int sim_buf_pop(struct simsock *v, void *data, int *size) {  	// Buffer Item get
	struct simbuf *curitem;
	int cnt = 0;

//	EnterCriticalSection(&v->lock);

	if (v->queue==NULL) {
//		LeaveCriticalSection(&v->lock);
		return cnt;
	}


	curitem = v->queue;
	v->queue = curitem->next;
	CopyMemory(data,curitem->data,min(curitem->size, *size));
	*size=curitem->size;
	free(curitem->data);
	free(curitem);

	curitem = v->queue;

	if (!curitem) {
//		LeaveCriticalSection(&v->lock);
		return cnt;
	}

	cnt++;

	while (curitem->next) {
		curitem = curitem->next;
		cnt++;
	}

//	LeaveCriticalSection(&v->lock);

	return cnt;
}

struct simsock *sim_sock_new(void) {			   				// Socket Create
	struct simsock *v;

	v=malloc(sizeof(struct simsock));

	ZeroMemory(v,sizeof(struct simsock));

	v->block = FALSE;
	v->under = CreateEvent(0,TRUE,FALSE,NULL);
	v->over  = CreateEvent(0,TRUE,TRUE,NULL);
	v->lock  = CreateEvent(0,FALSE,TRUE,NULL);
	DEBU(G "sock_new InitCrit\n");
//	InitializeCriticalSection(&v->lock);
	return v;
}

void sim_sock_destroy(struct simsock *v) {			   			// Socket destroy
	CloseHandle(v->under);
	CloseHandle(v->over);
	CloseHandle(v->lock);
	free(v);
}

int sim_sock_write(struct simsock *v, void *data, int size) {	// Socket Write to Next

	if (v->block)
		WaitForSingleObject(v->next->over,INFINITE);
	WaitForSingleObject(v->next->lock,INFINITE);

	if (sim_buf_push(v->next, data, size)>SIMSIZE)
		ResetEvent(v->next->over); // Unlock Write if not Full Queue
	SetEvent(v->next->under);

	SetEvent(v->next->lock); // Unlock Queue

	return size;
}

int sim_sock_read(struct simsock *v, void *data, int size) { 	// Socket Read

	WaitForSingleObject(v->under,INFINITE);
	WaitForSingleObject(v->lock,INFINITE);

	if (sim_buf_pop(v,data,&size)<=0)
		ResetEvent(v->under);   // UnLock Read by not Empty Queue
	SetEvent(v->over);			// Unlock Write after Read

	SetEvent(v->lock);          // Unlock Queue

	if (data)
		return size;
	else
		return -1;
}

int socketpair (int family, int type, int protocol, struct simsock *sb[2])
{
	sb[0]=sim_sock_new();
	sb[1]=sim_sock_new();

	sb[0]->next = sb[1];
	sb[1]->next = sb[0];

	return 0;
}

