/*
 * Gnophone: A client for the Asterisk PBX
 *
 * Copyright (C) 2000, Linux Support Services, Inc.
 *
 * Written by Mark Spencer
 *
 * Linux/UNIX version distributed under the terms of
 * the GNU General Public License
 *
 * audio.c: Generic Audio/Telephony Interface
 *
 */

#ifdef WIN32

  #include <stdio.h>
  #include <winpoop.h>

//  #include "gnophone.h"
  #include "audio.h"

  #include "phonecore.h"
  #include <iax-client.h>

#else

  #include <gtk/gtk.h>
  #include <stdio.h>

  #include "gnophone.h"
  #include "audio.h"

  #include "phonecore.h"
  #include <iax/iax-client.h>

#endif

struct audio_channel *audioc = NULL;
struct audio_channel *aclist = NULL;

int audio_select(struct audio_channel *c)
{
	return pc_select_audio(c);
}

struct audio_channel *audio_new()
{
	struct audio_channel *ac;
#ifdef WIN32
	ac = malloc(sizeof(struct audio_channel));
	bzero(ac, sizeof(struct audio_channel));
#else
	ac = g_new0(struct audio_channel, 1);
#endif
	ac->id = -1;
	ac->dpid = -1;
	return ac;
}

int audio_register_channel(struct audio_channel *c)
{
	static struct audio_channel *last = NULL;

	DEBU(G "Registering %s\n", c->name);

	if (last)
		last->next = c;
	else
		aclist = c;

	last = c;
	return 0;
}

int send_digit(char digit)
{
	pc_event e;
	e.event = PC_EVENT_AUDIO_DIGIT;
	e.e.dtmf.dtmf = digit;
	return pc_write_event(SOURCE_GUI, &e);
}

int audio_ring(void)
{
	return pc_simple_event(SOURCE_GUI, -1, PC_EVENT_AUDIO_RING);
}

int audio_ringing(void)
{
	return pc_simple_event(SOURCE_GUI, -1, PC_EVENT_AUDIO_RINGING);
}

int audio_shutup(void)
{
	return pc_simple_event(SOURCE_GUI, -1, PC_EVENT_AUDIO_SHUTUP);
}

int audio_deactivate(void)
{
	return pc_simple_event(SOURCE_GUI, -1, PC_EVENT_AUDIO_DEACTIVATE);
}
