/*
 * Gnophone: A client for the Asterisk PBX
 *
 * Copyright (C) 2000, Linux Support Services, Inc.
 *
 * Written by Mark Spencer
 *
 * Linux/UNIX version distributed under the terms of
 * the GNU General Public License
 *
 * gaudio.h: Shared definitions and callback functions for gnophone audio
 *
 */


#ifndef _GNOPHONE_AUDIO_H
#define _GNOPHONE_AUDIO_H

#ifdef WIN32
	#include <time.h>
	#include <winsock2.h>
#else
	#include <sys/time.h>
#endif

struct audio_channel {

	struct audio_channel *next; /* For linking */
	char name[80];
	int  priority;			/* Higher priority == I'm a better interface */
	char *driver;
	int (*open)(struct audio_channel *c);
	int (*close)(struct audio_channel *c);
	int (*play_digit)(struct audio_channel *c, char digit);
	int (*activate)(struct audio_channel *c);
	int (*ring)(struct audio_channel *c);
	int (*busy)(struct audio_channel *c);
	int (*fastbusy)(struct audio_channel *c);
	int (*ringing)(struct audio_channel *c);
	int (*deactivate)(struct audio_channel *c);
	int (*configure)(struct audio_channel *c);
	int (*flush)(struct audio_channel *c);	/* Flush channel if no more data coming */
	int (*sendaudio)(struct audio_channel *c, int format, void *data, int len);
	int (*readaudio)(struct audio_channel *c, int format, void *data, int *len);
	int (*exception)(struct audio_channel *c);
	int (*setspeed)(struct audio_channel *c, int speed);
	/* Simulated full duplex - this routine should switch between read
	   and write mode on non-duplex channels */
	int (*simduplex)(struct audio_channel *c, int write);
	int sformats;		/* Supported formats */
	int cananswer;		/* 0 if channel cannot indicate someone answering
						   1 if the channel can indicate it */
	int duplex;			/* True if the device is a full duplex device */
	int echocancelled;	/* True if the device has built in echo cancellation */
	int fd;				/* File descriptor for selecting() on */
	int hz;				/* Hz we're running at */
	/* Some convenience fields for the driver */
	void *pvt;			/* Private stuff by channel driver for everything else */

	/* Standard playback stuff */
	struct timeval 	st;	/* When we last were here */
	int pos;
	int id;				/* Sched ID */
	int repeat;			/* Repeat */
	int totallen;		/* Total length of sample (in samples) */
	int lensofar;		/* How much has been played so far (in samples) */
	short *sound;		/* The sound data itself */

	/* Simulated full duplex */
	int writemode;
	/* Duplex mode auto-switch ID */
	int dpid;
} *aclist;

extern struct audio_channel *audioc;
extern struct audio_channel *audio_new();

#define AUDIO_DEFAULT_SPEED 8000

/* Default level of sound to consider "silence" for silence
   suppression and simulated full duplex */

#define DEFAULT_SUPPRESSION 5

#define DEFAULT_SWITCHTIME 800

/* Some standard functions for non-telephony devices */
extern int std_play_digit(struct audio_channel *c, char digit);
extern int std_ring(struct audio_channel *c);
extern int std_ringing(struct audio_channel *c);
extern int std_busy(struct audio_channel *c);
extern int std_fastbusy(struct audio_channel *c);

extern int audio_register_channel(struct audio_channel *c);
extern int audio_select(struct audio_channel *c);
extern int audio_ring(void);
extern int audio_ringing(void);
extern int audio_shutup(void);
extern int audio_deactivate(void);

/* Audio stuff */
extern int oss_audio_init(void);
extern int esd_audio_init(void);
extern int alsa_audio_init(void);
extern int send_digit(char digit);
extern int set_rec_source(void);
extern int pc_select_audio(struct audio_channel *c);

#endif
