/*
 * Asterisk Tool
 *
 * Andre Bierwirth <bierwirth@kmb.de>
 *
 * Copyright(C) Andre Bierwirth
 *
 * Distributed under the terms of the GNU General Public License (GPL) Version 2
 *
 * Windows Winsock Poll Emulation
 *
 */

#ifndef _WINPOLL_H
#define _WINPOLL_H


#define POLLIN          0x001           /* There is data to read.  */
#define POLLPRI         0x002           /* There is urgent data to read.  */
#define POLLOUT         0x004           /* Writing now will not block.  */

#define POLLERR         0x008           /* Error condition.  */
#define POLLHUP         0x010           /* Hung up.  */
#define POLLNVAL        0x020           /* Invalid polling request.  */



struct pollfd
  {
    int fd;                     /* File descriptor to poll.  */
    short int events;           /* Types of events poller cares about.  */
    short int revents;          /* Types of events that actually occurred.  */
  };



int poll (struct pollfd *fds, unsigned int nfds, int timeout);


#endif

