/*
 * Asterisk Tool
 *
 * Andre Bierwirth <bierwirth@kmb.de>
 *
 * Copyright(C) Andre Bierwirth
 *
 * Distributed under the terms of the GNU General Public License (GPL) Version 2
 *
 * Windows Local Socket Emulation
 *
 */

#ifndef _WINQUEUE_H_
#define _WINQUEUE_H_


struct simbuf {
	void 		  *data;
	int 		  size;
	struct simbuf *next;
};

struct simsock {
	struct simbuf 		*queue;
	BOOL				block;
	HANDLE 				under;
	HANDLE				over;
	HANDLE				lock;
	struct simsock		*next;
};

int sim_buf_push(struct simsock *v, void *data, int size);
int sim_buf_pop(struct simsock *v, void *data, int *size);

struct simsock *sim_sock_new(void);
void 		   sim_sock_free(struct simsock *v);

int sim_sock_write(struct simsock *v, void *data, int size);
int sim_sock_read(struct simsock *v, void *data, int size);

#endif
