unit clientcaller;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, ComCtrls, IAX, jpeg;

type
  TfrCaller = class(TFrame)
    Bevel: TBevel;
    lblPeerTitle: TLabel;
    pnlImage: TPanel;
    cbLinkBrs: TCheckBox;
    Button1: TButton;
    Label2: TLabel;
    gbLevel: TGroupBox;
    bHold: TSpeedButton;
    bConf: TSpeedButton;
    bDirect: TSpeedButton;
    bAnswer: TButton;
    bHangup: TButton;
    PeerStatus: TStaticText;
    lblLag: TLabel;
    tbLevel: TTrackBar;
    pbLevel: TProgressBar;
    Image: TImage;
    procedure bHangupClick(Sender: TObject);
    procedure bAnswerClick(Sender: TObject);
    procedure ImageDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ImageUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure cbLinkBrsClick(Sender: TObject);
  private
    { Private-Deklarationen }
    FPeer: TIAXPeer;
    procedure CMRelease(var Message: TMessage); message CM_RELEASE;
  public
    { Public-Deklarationen }
    procedure Release;
    property Peer: TIAXPeer read FPeer Write FPeer;
  end;

implementation

{$R *.DFM}

procedure TfrCaller.CMRelease(var Message: TMessage);
begin
  Free;
end;

procedure TFRCaller.Release;
begin
  PostMessage(Handle, CM_RELEASE, 0, 0);
end;


procedure TfrCaller.bHangupClick(Sender: TObject);
begin
  FPeer.DoHangup('');
end;

procedure TfrCaller.bAnswerClick(Sender: TObject);
begin
  FPeer.DoAnswer;
end;

procedure TfrCaller.ImageDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  pnlImage.BevelOuter:=bvLowered;
end;

procedure TfrCaller.ImageUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  pnlImage.BevelOuter:=bvRaised;
end;

procedure TfrCaller.cbLinkBrsClick(Sender: TObject);
begin
	FPeer.DoLinked(cbLinkBrs.Checked);
end;

end.
