unit guimain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, IAX, ActnList, Menus,
  clientcaller, OleCtrls, SHDocVw, Buttons,IAXGraph, Animate, GIFCtrl,
  jpeg;

type
  TForm1 = class(TForm)
    IAX: TIAX;
    StatusBar1: TStatusBar;
    PageControl1: TPageControl;
    TabBrowser: TTabSheet;
    Panel4: TPanel;
    WebBrowser: TWebBrowser;
    TabCalls: TTabSheet;
    MainMenu1: TMainMenu;
    Test1: TMenuItem;
    GnoPhonecom1: TMenuItem;
    Preferences1: TMenuItem;
    Audio1: TMenuItem;
    Video1: TMenuItem;
    Telefony1: TMenuItem;
    ActionList1: TActionList;
    AudioEditProperties: TAction;
    ScrollBox1: TScrollBox;
    Panel2: TPanel;
    GroupBox1: TGroupBox;
    bCall: TButton;
    Panel1: TPanel;
    Btn13: TButton;
    Btn14: TButton;
    Btn15: TButton;
    Btn16: TButton;
    Btn17: TButton;
    Btn18: TButton;
    Btn19: TButton;
    Btn20: TButton;
    Btn21: TButton;
    Btn22: TButton;
    Btn23: TButton;
    Btn24: TButton;
    pnlImage: TPanel;
    Image: TImage;
    VoiceOutput: TGroupBox;
    Bar1: TProgressBar;
    zSlideBar1: TTrackBar;
    Panel3: TPanel;
    Label1: TLabel;
    RxGIFAnimator1: TRxGIFAnimator;
    BrsBack: TBitBtn;
    BrsForward: TBitBtn;
    BrsReload: TBitBtn;
    BrsHome: TBitBtn;
    BrsStop: TBitBtn;
    BrowserAdress: TEdit;
    procedure bCallClick(Sender: TObject);
    procedure IAXStatus(Sender: TObject; Value: String);
    procedure Button1Click(Sender: TObject);
    procedure IAXPeer(Peer: TIAXPeer; ET: TIAXPeerEventType);
    procedure WebBrowserDownloadBegin(Sender: TObject);
    procedure BrowserAdressKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure WebBrowserDocumentComplete(Sender: TObject;
      const pDisp: IDispatch; var URL: OleVariant);
    procedure WebBrowserNavigateComplete2(Sender: TObject;
      const pDisp: IDispatch; var URL: OleVariant);
    procedure WebBrowserNewWindow2(Sender: TObject; var ppDisp: IDispatch;
      var Cancel: WordBool);
    procedure FormCreate(Sender: TObject);
    procedure ImageDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ImageUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure WebBrowserTitleChange(Sender: TObject;
      const Text: WideString);
    procedure IAXCallStart(Modal: Boolean; Dial: String);
    procedure IAXCallEnd(Sender: TObject);
    procedure DigitClick(Sender: TObject);
    procedure IAXUrl(Sender: TObject; URL: String);
    procedure BrsHomeClick(Sender: TObject);
    procedure BrsStopClick(Sender: TObject);
    procedure BrsReloadClick(Sender: TObject);
    procedure BrsForwardClick(Sender: TObject);
    procedure BrsBackClick(Sender: TObject);
    procedure WebBrowserCommandStateChange(Sender: TObject;
      Command: Integer; Enable: WordBool);
    procedure IAXLevel(Sender: TObject; Value: Double);
  private
    { Private-Deklarationen }
    CurDispatch: IDispatch;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

uses IAXCall;

{$R *.DFM}

procedure TForm1.bCallClick(Sender: TObject);
begin
  IAX.Call;
end;

procedure TForm1.IAXStatus(Sender: TObject; Value: String);
begin
  StatusBar1.SimpleText := Value;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
	IAX.DoRinging;
end;

procedure TForm1.IAXPeer(Peer: TIAXPeer; ET: TIAXPeerEventType);
var
  MyFrame: TfrCaller;
  I: Integer;
begin
	MyFrame:=TfrCaller(Peer.UserData);
  case ET of
    ipeCreate: begin
      PageControl1.ActivePageIndex:=1;
      MyFrame:=TfrCaller.Create(ScrollBox1);
		  MyFrame.Parent := ScrollBox1;
      MyFrame.Peer:=Peer;
		  MyFrame.Name := '';
      Peer.UserData:=MyFrame;
    end;
    ipeDestroy: begin
      TfrCaller(Peer.UserData).Free;
      Peer.UserData:=nil;
      if IAX.Peers.Count=0 then
        PageControl1.ActivePageIndex:=0;
    end;
    ipeTitle: 		MyFrame.lblPeerTitle.Caption:=Peer.Title;
    ipeImage: 		MyFrame.Image.Picture.Assign(Peer.Image);
    ipeLinked: 		MyFrame.cbLinkBrs.Checked := Peer.Linked;
    ipeEnabled: begin
      for I:=0 to MyFrame.ControlCount-1 do
        MyFrame.Controls[I].Enabled := Peer.Enabled;
    end;
//    ipeMute: 		MyFrame.bMute.Down:=Peer.Mute
    ipeLagRep: 		MyFrame.lblLag.Caption:=Format('%dms / %dms',[Peer.Lag,Peer.Jitter]);
    ipeLevel: 		MyFrame.pbLevel.Position:=Round(Peer.Level*100);
    ipeHold: 			MyFrame.bHold.Down:=Peer.Hold;
    ipeCanAnswer: MyFrame.bAnswer.Enabled:=Peer.Answer;
    ipeStatus: 		MyFrame.PeerStatus.Caption:=Peer.Status;
    ipeURL: 			begin
      if BrowserAdress.Text<>Peer.URL then
      begin
        PageControl1.ActivePageIndex:=0;
	    	WebBrowser.Navigate(Peer.URL);
      end;
    end;
  end;
end;

procedure TForm1.WebBrowserDownloadBegin(Sender: TObject);
begin
  RxGIFAnimator1.Animate:=True;
end;

procedure TForm1.BrowserAdressKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key=VK_RETURN) then
  begin
    IAX.Entry(BrowserAdress.Text);
  end;
end;

procedure TForm1.WebBrowserDocumentComplete(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
begin
  if (pDisp = CurDispatch) then
  begin
    RxGIFAnimator1.Animate:=False;
    RxGIFAnimator1.FrameIndex:=0;
    CurDispatch := nil; {die globale Variable leeren}
  end;
end;

procedure TForm1.WebBrowserNavigateComplete2(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
begin
  if CurDispatch = nil then
    CurDispatch := pDisp; {fr Vergleichszwecke speichern}
  if pDisp = WebBrowser.DefaultInterface then
  begin
    BrowserAdress.Text := URL;
  end;
end;

procedure TForm1.WebBrowserNewWindow2(Sender: TObject;
  var ppDisp: IDispatch; var Cancel: WordBool);
begin
 Cancel:=True;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  try
  if IAX.UserImage<>'' then
    Image.Picture.LoadFromFile(IAX.UserImage);
  except
  end;
  if Image.Picture=nil then
	  Image.Picture.Assign(IAX.DefaultImage);

  SetPriorityClass(GetCurrentProcess(), HIGH_PRIORITY_CLASS);
//  SetThreadPriority(GetCurrentThread(), THREAD_PRIORITY_TIME_CRITICAL);
  BrsHomeClick(Self);
end;

procedure TForm1.ImageDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  pnlImage.BevelOuter:=bvLowered;
end;

procedure TForm1.ImageUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  pnlImage.BevelOuter:=bvRaised;
end;

procedure TForm1.WebBrowserTitleChange(Sender: TObject;
  const Text: WideString);
begin
  Caption := 'IAXPhone: '+Text;
end;

procedure TForm1.IAXCallStart(Modal: Boolean; Dial: String);
begin
  if frmCall=nil then
  begin
    frmCall:=TFrmCall.Create(Self);
    frmCall.IAX:=IAX;
    if Modal then
    begin
      frmCall.edcalladdr.Text:=Dial;
      frmCall.ShowModal;
      FreeAndNil(frmCall);
    end else
      frmCall.Visible:=True;
  end else
    if Modal then
    begin
      if Length(Dial)=0 then
	      frmCall.bCallClick(Self);
    end;

  if not Modal then
  begin
	    frmCall.edcalladdr.Text:=frmCall.edcalladdr.Text+Dial;
	    frmCall.edcalladdr.SelStart:=Length(frmCall.edcalladdr.Text);
	    frmCall.edcalladdr.SelLength:=0;
  end;
end;

procedure TForm1.IAXCallEnd(Sender: TObject);
begin
  if frmCall<>nil then
    frmCall.Release;
end;

procedure TForm1.DigitClick(Sender: TObject);
begin
  IAX.Dialdigit(TButton(Sender).Caption[1]);
end;

procedure TForm1.IAXUrl(Sender: TObject; URL: String);
begin
  PageControl1.ActivePageIndex:=0;
  WebBrowser.Navigate(URL);
end;

procedure TForm1.BrsHomeClick(Sender: TObject);
begin
 	BrowserAdress.Text := 'http://gnophone.com/directory/';
  IAX.Entry(BrowserAdress.Text);
end;

procedure TForm1.BrsStopClick(Sender: TObject);
begin
  WebBrowser.Stop;
end;

procedure TForm1.BrsReloadClick(Sender: TObject);
begin
	WebBrowser.Refresh;
end;

procedure TForm1.BrsForwardClick(Sender: TObject);
begin
	WebBrowser.GoForward;
end;

procedure TForm1.BrsBackClick(Sender: TObject);
begin
	WebBrowser.GoBack;
end;

procedure TForm1.WebBrowserCommandStateChange(Sender: TObject;
  Command: Integer; Enable: WordBool);
begin
 case Command of
    CSC_NAVIGATEBACK: BrsBack.Enabled := Enable;
    CSC_NAVIGATEFORWARD: BrsForward.Enabled := Enable;
    CSC_UPDATECOMMANDS: BrsStop.Enabled := TWebBrowser(Sender).Busy;
 end;
end;

procedure TForm1.IAXLevel(Sender: TObject; Value: Double);
begin
	Bar1.Position := Round(Value*100);
end;

end.
