{*******************************************************}
{                                                       }
{       IAX Phone Component for Delphi                  }
{       by Andre Bierwirth bierwirth@kmb.de             }
{                                                       }
{       Copyright (c) 2002 KMB Software 								}
{                                                       }
{*******************************************************}

unit IAXGraph;

interface


uses windows,classes, graphics, rxgif, jpeg;

function DetectFormat(S: TStream): TGraphicClass; OverLoad;
function DetectFormat(Data: Pointer; Datalen: Longint): TGraphicClass; Overload;

procedure AssignDefaultImage(P: TPicture);

implementation

uses sysutils;

function DetectFormat(S: TStream): TGraphicClass;  OverLoad;
var
  Data: Pointer;
begin
  Result := nil;
  GetMem(Data,S.Size);
  S.Read(Data^,S.Size);
  Result := DetectFormat(Data,S.Size);
  FreeMem(Data,S.Size);
end;

function DetectFormat(Data: Pointer; Datalen: Longint): TGraphicClass; Overload;

  function CanLoadGIF: Boolean;
  type
    TGIFHeader = packed record
      Signature: array[0..2] of Char; // magic ID 'GIF'
      Version: array[0..2] of Char;   // '87a' or '89a'
    end;

    TLogicalScreenDescriptor = packed record
      ScreenWidth: Word;
      ScreenHeight: Word;
      PackedFields,
      BackgroundColorIndex,
      AspectRatio: Byte;
    end;

    TImageDescriptor = packed record
      //Separator: Byte;
      Left: Word;
      Top: Word;
      Width: Word;
      Height: Word;
      PackedFields: Byte;
    end;
  var
    Header: TGIFHeader;
    LastPosition: Cardinal;
  begin
    Result := DataLen > (SizeOf(TGIFHeader) + SizeOf(TLogicalScreenDescriptor) + SizeOf(TImageDescriptor));
    if Result then
    begin
      Move(Data^,Header, SizeOf(Header));
      Result := UpperCase(Header.Signature) = 'GIF';
    end;
  end;

  function CanLoadBMP: Boolean;
  type
    TBitmapFileHeader = packed record
      bfType: Word;
      bfSize: DWORD;
      bfReserved1: Word;
      bfReserved2: Word;
      bfOffBits: DWORD;
    end;
    TBitmapInfoHeader = packed record
      biSize: DWORD;
      biWidth: Longint;
      biHeight: Longint;
      biPlanes: Word;
      biBitCount: Word;
      biCompression: DWORD;
      biSizeImage: DWORD;
      biXPelsPerMeter: Longint;
      biYPelsPerMeter: Longint;
      biClrUsed: DWORD;
      biClrImportant: DWORD;
    end;
    TRgbQuad = packed record
      rgbBlue: Byte;
      rgbGreen: Byte;
      rgbRed: Byte;
      rgbReserved: Byte;
    end;

  var
    Pos: Integer;
		Off, Size, ColorCount : Integer;
    BFH: TBitmapFileHeader;
    BIH: TBitmapInfoHeader;

    function tRead(Buffer: Pointer; Count: Longint): Longint;
    var
      Remain: Longint;
      pPos: Pointer;
    begin
      Remain:=Datalen-Pos;
      if Remain<Count then
        Count:=Remain;
      if Assigned(Buffer) then
      begin
        pPos:=Pointer(Integer(Data)+Pos);
        Move(pPos^,Buffer^,Count);
      end;
      Inc(Pos,Count);
      Result := Count;
    end;

  begin
    Result := False;
    Pos:=0;

    if tRead(@BFH, SizeOf(BFH)) <> SizeOf(BFH) then Exit;
    Off := 0; Size := 0;

    if BFH.bfType <> $4D42 then
       Pos := 0 // Retry without header
    else
    begin
       Off := BFH.bfOffBits;
       Size := BFH.bfSize;
    end;
    if tRead(@BIH, SizeOf(BIH)) <> SizeOf(BIH) then Exit;
    if not (BIH.biBitCount in [1,4,8,15,16,24,32]) then Exit;
    ColorCount := 0;
    if BIH.biBitCount <= 8 then
       ColorCount := (1 shl BIH.biBitCount) * Sizeof( TRGBQuad );
    if Off > 0 then
    begin
       Off := Off - Sizeof( TBitmapFileHeader ) - Sizeof( TBitmapInfoHeader );
       if Off <> ColorCount then
          ColorCount := Off;
    end;
    if ColorCount > 0 then
       if tRead(nil,ColorCount) <> DWord(ColorCount) then Exit;
    if Size=0 then
			Size := (((BIH.biBitCount * BIH.biWidth + 31) div 32) * 4) * BIH.biHeight
    else
      Size := Size - SizeOf(TBitmapFileHeader) - SizeOf(TBitmapInfoHeader) - ColorCount;
    if tRead(nil,Size) <> DWord(Size) then Exit;
    Result := True;
  end;

  function CanLoadJPEG: Boolean;
	const
	  JFIF_LEN = 14;
  var
    Pos: Longint;

    SOIAM: array [0..3] of Byte;

    d: byte;
    Length: Word;

	  b : Array[0..JFIF_LEN-1] of Byte;

    major: Byte;
    minor: Byte;

    density_unit: Byte;
		X_density: Word;
    Y_density: Word;

    function tRead(Buffer: Pointer; Count: Longint): Longint;
    var
      Remain: Longint;
      pPos: Pointer;
    begin
      Remain:=Datalen-Pos;
      if Remain<Count then
        Count:=Remain;
      if Assigned(Buffer) then
      begin
        pPos:=Pointer(Integer(Data)+Pos);
        Move(pPos^,Buffer^,Count);
      end;
      Inc(Pos, Count);
      Result := Count;
    end;

  begin
    Result := False;
    Pos:=0;

    // Read Check Start
    if tRead(@SOIAM,4)<4 then Exit;
    if (SOIAM[0]<>$FF) or (SOIAM[1]<>$D8) or (SOIAM[2]<>$FF) or (SOIAM[3]<>$E0) then Exit;

    Length := 0;
    if tRead(@Length,1)<1 then Exit;
    Length := Length shl 8;
    if tRead(@Length,1)<1 then Exit;

    Dec(Length,2);

	  { See if a JFIF APP0 marker is present }
    if (Length >= JFIF_LEN) then
    begin
      if tRead(@b,JFIF_LEN)<JFIF_LEN then exit;
      Dec(Length,JFIF_LEN);
	    if (b[0]=$4A) and (b[1]=$46) and (b[2]=$49) and (b[3]=$46) and (b[4]=0) then
	    begin
  	    { Found JFIF APP0 marker: check version }
	      { Major version must be 1, anything else signals an incompatible change.
        We used to treat this as an error, but now it's a nonfatal warning,
        because some bozo at Hijaak couldn't read the spec.
        Minor version should be 0..2, but process anyway if newer. }
        major:=b[5];
        minor:=b[6];

				density_unit := b[7];
      	X_density := (b[8] shl 8) + b[9];
      	Y_density := (b[10] shl 8) + b[11];
      	if (b[12] or b[13]) <> 0 then // Have Thumbnail
	      	if (length <> (Longint(b[12]) * Longint(b[13]) * Longint(3))) then Exit; // Bad Thumb Size
      end else
	    begin
  	    // No JFIF header
        Exit;
	    end;
    end else
    begin
      Exit;
	    { Too short to be JFIF marker }
    end;

	  if (length > 0) then          { skip any remaining data -- could be lots }
      Inc(Pos,Length);

    Result := True;
    // End App0
  end;

begin
  Result := nil;
  if CanLoadGif then Result := TGIFImage
  else if CanLoadBMP then Result := TBitmap
  else if CanLoadJPEG then Result := TJPEGImage;
end;

procedure AssignDefaultImage(P: TPicture);
var
  J: TJPEGImage;
  R: TResourceStream;
begin
  J:=TJPEGImage.Create;
  R:=TResourceStream.Create(HInstance,'IAX_DEFAULT_IMAGE', RT_RCDATA);
  try
    J.LoadFromStream(R);
    P.Assign(J);
  except
  end;
  J.Free;
end;

end.
