unit IAXPHONE;

{
   Asterisk -- A telephony toolkit for Linux.

   Implementation of Inter-Asterisk eXchange

   Copyright (C) 1999, Mark Spencer

   Mark Spencer <markster@linux-support.net>

   Translated to Delphi by
   Andre Bierwirth <bierwirth@kmb.de>

   This program is free software, distributed under the terms of
   the GNU General Public License
}


interface
uses
  Windows, winsock;

{ Translated from IAXPHONE.H }

const
  PC_EVENT_IMAGE = 1;
  PC_EVENT_AUDIO = 2;
  PC_EVENT_LOADCOMPLETE = 3;
  PC_EVENT_DTMF = 4;
  PC_EVENT_HANGUP = 5;
  PC_EVENT_ANSWER = 6;
  PC_EVENT_REJECT = 7;
  PC_EVENT_ACCEPT = 8;
  PC_EVENT_AUTHRQ = 9;
  PC_EVENT_AUTHRP = 10;
  PC_EVENT_URL = 11;
  PC_EVENT_RINGA = 12;
  PC_EVENT_REGREP = 13;
  PC_EVENT_CONNECT = 14;
  PC_EVENT_SELECT = 15;
  PC_EVENT_NEW = 16;
  PC_EVENT_NEW_REPLY = 17;
  PC_EVENT_SELAUDIO = 18;
  PC_EVENT_AUDIO_REPLY = 19;
  PC_EVENT_REGREQ = 20;
  PC_EVENT_AUDIO_READY = 21;

  PC_EVENT_AUDIO_DIGIT = 22;
  PC_EVENT_AUDIO_RING = 23;
  PC_EVENT_AUDIO_RINGING = 24;
  PC_EVENT_AUDIO_SHUTUP = 25;
  PC_EVENT_AUDIO_DEACTIVATE = 26;
  PC_EVENT_ADDR = 27;
  PC_EVENT_CONFERENCE = 28;
  PC_EVENT_UNCONFERENCE = 29;

  PC_EVENT_ONHOOK = 30;
  PC_EVENT_OFFHOOK = 31;

  PC_EVENT_DIAL = 32;

  PC_EVENT_DIAL_TBD = 33;
  PC_EVENT_DPREQ = 34;
  PC_EVENT_DPREP = 35;
  PC_EVENT_COMPLETE = 36;
  PC_EVENT_TRANSFER = 37;
  PC_EVENT_LAGREQ = 38;
  PC_EVENT_LAGREP = 39;
  PC_EVENT_UNLINK = 40;
  PC_EVENT_LINKREJECT = 41;
  PC_EVENT_TEXT = 42;

  PC_REG_SUCCESS = 1;
  PC_REG_REJECT = 2;
  PC_REG_TIMEOUT = 3;

{+// No more than 32 calls simulataneously*/ }
  PC_MAX_CALLS = 32;

type
  text_event = record
    text: Array[0..8192-1] of Byte;
  end {text_event};

  image_event = record
    datalen: Integer;
{+// No images more than 16k*/ }
    data: Array[0..8192-1] of Byte;
  end {image_event};

  audio_event = record
{+// Audio level change*/ }
    level: Integer;
  end {audio_event};

  dpreq_event = record
    dest: Array[0..256-1] of Byte;
  end {dpreq_event};

  dprep_event = record
    number: Array[0..256-1] of Byte;
    exists: Integer;
    canexist: Integer;
    nonexistant: Integer;
    ignorepat: Integer;
  end {dprep_event};

  lagrep_event = record
    lag: Integer;
    jitter: Integer;
  end {lagrep_event};

  dtmf_event = record
    dtmf: Char;
  end {dtmf_event};

  dial_event = record
    digit: Char;
  end {dial_event};

  hangup_event = record
    why: Array[0..256-1] of Char;
  end {hangup_event};

  reject_event = record
    why: Array[0..256-1] of Char;
  end {reject_event};

  connect_event = record
    callerid: Array[0..256-1] of Char;
    dest: Array[0..256-1] of Char;
    language: Array[0..256-1] of Char;
    addr: SOCKADDR_IN;
    dnid: Array[0..256-1] of Char;
  end {connect_event};

  addr_event = record
    addr: SOCKADDR_IN;
  end {addr_event};

  authrequest = record
    authmethods: Integer;
    challenge: Array[0..256-1] of Char;
    username: Array[0..256-1] of Char;
  end {authrequest};

  url_event = record
    url: Array[0..1024-1] of Char;
    link: Integer;
  end {url_event};

  registration_reply = record
    status: Integer;
    ourip: Array[0..256-1] of Char;
    callerid: Array[0..64-1] of Char;
    ourport: SmallInt;
    refresh: Integer;
  end {registration_reply};

  audio_select = record
    ac: Pointer;
    response: Integer;
  end {audio_select};

  auth_reply = record
    password: Array[0..256-1] of Char;
    challenge: Array[0..256-1] of Char;
    methods: Integer;
  end {auth_reply};

  new_reply = record
    id: Integer;
  end {new_reply};

  registration_request = record
    server: Array[0..256-1] of Char;
    peer: Array[0..256-1] of Char;
    secret: Array[0..256-1] of Char;
    refresh: Integer;
  end {registration_request};

{+// This is remarkably like the IAX events but oh well*/ }
(*
  pc_event = record
    len: Integer;
    callno: Integer;
    event: Integer;
    addr: ADDR_EVENT;
    image: IMAGE_EVENT;
    audio: AUDIO_EVENT;
    dtmf: DTMF_EVENT;
    dial: DIAL_EVENT;
    reject: REJECT_EVENT;
    hangup: HANGUP_EVENT;
    authrequest: AUTHREQUEST;
    regreply: REGISTRATION_REPLY;
    regrequest: REGISTRATION_REQUEST;
    url: URL_EVENT;
    connect: CONNECT_EVENT;
    authreply: AUTH_REPLY;
    newreply: NEW_REPLY;
    asel: AUDIO_SELECT;
    dpreq: DPREQ_EVENT;
    dprep: DPREP_EVENT;
    lag: LAGREP_EVENT;
    text: TEXT_EVENT;
  end {pc_event};
*)

  pc_event = record
    len: Integer;
    callno: Integer;
    event: Integer;
    case Integer of
    0: (addr: ADDR_EVENT);
    1: (image: IMAGE_EVENT);
    2: (audio: AUDIO_EVENT);
    3: (dtmf: DTMF_EVENT);
    4: (dial: DIAL_EVENT);
    5: (reject: REJECT_EVENT);
    6: (hangup: HANGUP_EVENT);
    7: (authrequest: AUTHREQUEST);
    8: (regreply: REGISTRATION_REPLY);
    9: (regrequest: REGISTRATION_REQUEST);
    10:(url: URL_EVENT);
    11:(connect: CONNECT_EVENT);
    12:(authreply: AUTH_REPLY);
    13:(newreply: NEW_REPLY);
    14:(asel: AUDIO_SELECT);
    15:(dpreq: DPREQ_EVENT);
    16:(dprep: DPREP_EVENT);
    17:(lag: LAGREP_EVENT);
    18:(text: TEXT_EVENT);
  end {pc_event};


  TDebugCallback = procedure (Text: PChar);cdecl;
  TNotifyCallback = procedure (Instance: Pointer);cdecl;
  TSetSpeedCallback = procedure (Instance: Pointer; Speed: Integer);cdecl;
  TSendAudioCallback = procedure (Instance: Pointer; Data: Pointer; Size: Longint);cdecl;
  TReadAudioCallback = procedure (Instance: Pointer; Data: Pointer; var Size: Longint);cdecl;

const
  SOURCE_GUI = 0;
  SOURCE_PC = 1;
  SOURCE_PRI_OUT = 2; {/* Priority out*/}
  SOURCE_PRI_IN = 3; {/* Priority in*/}

{$IFDEF IAXSTATIC}
function pc_simple_event(src: Integer;
                         callno: Integer;
                         event: Integer): Integer cdecl;

function pc_send_unlink(src: Integer;
                        callno: Integer): Integer cdecl;

function pc_send_link_reject(src: Integer;
                             callno: Integer): Integer cdecl;

function pc_send_lagreq(src: Integer;
                        callno: Integer): Integer cdecl;

function pc_transfer(src: Integer;
                     callno: Integer): Integer cdecl;

function pc_onhook(src: Integer;
                   callno: Integer): Integer cdecl;

function pc_offhook(src: Integer;
                    callno: Integer): Integer cdecl;

function pc_load_complete(src: Integer;
                          callno: Integer): Integer cdecl;

function pc_answer(src: Integer;
                   callno: Integer): Integer cdecl;

function pc_ring_announce(src: Integer;
                          callno: Integer): Integer cdecl;

function pc_accept(src: Integer;
                   callno: Integer): Integer cdecl;

function pc_select(src: Integer;
                   callno: Integer): Integer cdecl;

function pc_conference(src: Integer;
                       callno: Integer): Integer cdecl;

function pc_unconference(src: Integer;
                         callno: Integer): Integer cdecl;

function pc_dial_tbd(src: Integer;
                     callno: Integer): Integer cdecl;

function pc_send_linked_url(src: Integer;
                            callno: Integer;
                            url: PChar): Integer cdecl;

function pc_dial(src: Integer;
                 digit: Char): Integer cdecl;

function pc_send_text(src: Integer;
                      callno: Integer;
                      text: PChar): Integer cdecl;

function pc_addr(src: Integer;
                 callno: Integer;
                 addr: SOCKADDR_IN): Integer cdecl;

function pc_init: Integer cdecl;

function pc_write_event(src: Integer;
                        var e: PC_EVENT): Integer cdecl;

function pc_read_event(src: Integer;
                       var e: PC_EVENT): Integer cdecl;

function pc_send_dtmf(src: Integer;
                      callno: Integer;
                      digit: Char): Integer cdecl;


function pc_send_dpreq(src: Integer;
                       callno: Integer;
                       digits: PChar): Integer cdecl;

function pc_hangup(src: Integer;
                   callno: Integer;
                   why: PChar): Integer cdecl;

function pc_reject(src: Integer;
                   callno: Integer;
                   why: PChar): Integer cdecl;

function pc_auth_reply(src: Integer;
                       callno: Integer;
                       password: PChar;
                       challenege: PChar;
                       authmethods: Integer): Integer cdecl;

function pc_call(src: Integer;
                 pcid: Integer;
                 callerid: PChar;
                 destination: PChar;
                 lang: PChar): Integer cdecl;

function pc_complete(src: Integer;
                     callno: Integer;
                     dest: PChar): Integer cdecl;

function pc_register(src: Integer;
                     pcid: Integer;
                     server: PChar;
                     peer: PChar;
                     secret: PChar;
                     refresh: Integer): Integer cdecl;

function pc_session_new: Integer cdecl;
function pc_get_fd: Integer cdecl;
function pc_select_audio(var c: pointer): Integer cdecl;
function phonecore_thread(unused: Pointer): Pointer cdecl;
function pc_debug_callback(Handle: TDebugCallback): Longint cdecl;

function sound_toapp_init(instance: Pointer;
                          openaudio: TNotifyCallback;
                          closeaudio: TNotifyCallback;
                          activateaudio: TNotifyCallback;
                          deactivateaudio: TNotifyCallback;
                          configureaudio: TNotifyCallback;
                          setspeddaudio: TSetSpeedCallback;
													sendaudio: TSendAudioCallback;
													readaudio: TReadAudioCallback): Longint cdecl;

function sound_toapp_send(data: Pointer; len: Integer): Integer cdecl;

function audio_ringing: Integer cdecl;
function audio_ring: Integer cdecl;
function audio_shutup: Integer cdecl;
function audio_deactivate: Integer cdecl;

{$ELSE}
var
pc_simple_event: 			function (src: Integer;
                         				callno: Integer;
                         				event: Integer): Integer cdecl;

pc_send_unlink: 			function (src: Integer;
               									callno: Integer): Integer cdecl;

pc_send_link_reject: 	function (src: Integer;
                    						callno: Integer): Integer cdecl;

pc_send_lagreq: 			function (src: Integer;
               									callno: Integer): Integer cdecl;

pc_transfer: 					function (src: Integer;
            										callno: Integer): Integer cdecl;

pc_onhook: 						function (src: Integer;
          											callno: Integer): Integer cdecl;

pc_offhook: 					function (src: Integer;
           											callno: Integer): Integer cdecl;

pc_load_complete: 		function (src: Integer;
                 								callno: Integer): Integer cdecl;

pc_answer: 						function (src: Integer;
          											callno: Integer): Integer cdecl;

pc_ring_announce: 		function (src: Integer;
                 								callno: Integer): Integer cdecl;

pc_accept: 						function (src: Integer;
          											callno: Integer): Integer cdecl;

pc_select: 						function (src: Integer;
          											callno: Integer): Integer cdecl;

pc_conference: 				function (src: Integer;
              									callno: Integer): Integer cdecl;

pc_unconference: 			function (src: Integer;
                								callno: Integer): Integer cdecl;

pc_dial_tbd: 					function (src: Integer;
            										callno: Integer): Integer cdecl;

pc_send_linked_url: 	function (src: Integer;
                   							callno: Integer;
                   							url: PChar): Integer cdecl;

pc_dial: 							function (src: Integer;
        												digit: Char): Integer cdecl;

pc_send_text:				 	function (src: Integer;
             										callno: Integer;
             										text: PChar): Integer cdecl;

pc_addr: 							function (src: Integer;
        												callno: Integer;
        												addr: SOCKADDR_IN): Integer cdecl;

pc_init:							function : Integer cdecl;

pc_write_event: 			function (src: Integer;
               									var e: PC_EVENT): Integer cdecl;

pc_read_event: 				function (src: Integer;
              									var e: PC_EVENT): Integer cdecl;

pc_send_dtmf:					function (src: Integer;
             										callno: Integer;
             										digit: Char): Integer cdecl;


pc_send_dpreq: 				function (src: Integer;
              									callno: Integer;
              									digits: PChar): Integer cdecl;

pc_hangup: 						function (src: Integer;
          											callno: Integer;
          											why: PChar): Integer cdecl;

pc_reject : 					function (src: Integer;
          											callno: Integer;
          											why: PChar): Integer cdecl;

pc_auth_reply : 			function (src: Integer;
              									callno: Integer;
              									password: PChar;
              									challenege: PChar;
              									authmethods: Integer): Integer cdecl;

pc_call: 							function (src: Integer;
        												pcid: Integer;
        												callerid: PChar;
        												destination: PChar;
        												lang: PChar): Integer cdecl;

pc_complete: 					function (src: Integer;
            										callno: Integer;
            										dest: PChar): Integer cdecl;

pc_register: 					function (src: Integer;
            										pcid: Integer;
            										server: PChar;
            										peer: PChar;
            										secret: PChar;
            										refresh: Integer): Integer cdecl;

pc_session_new: 			function : Integer cdecl;
pc_get_fd:            function : Integer cdecl;
pc_select_audio: 			function (var c: pointer): Integer cdecl;
phonecore_thread: 		function (unused: Pointer): Pointer cdecl;
pc_debug_callback: 		function (Handle: TDebugCallback): Longint cdecl;

sound_toapp_init: 		function (instance: Pointer;
                 								openaudio: TNotifyCallback;
                 								closeaudio: TNotifyCallback;
                 								activateaudio: TNotifyCallback;
                 								deactivateaudio: TNotifyCallback;
                 								configureaudio: TNotifyCallback;
                 								setspeddaudio: TSetSpeedCallback;
																sendaudio: TSendAudioCallback;
																readaudio: TReadAudioCallback): Longint cdecl;

sound_toapp_send:			function (data: Pointer; len: Integer): Integer cdecl;

audio_ringing: 				function :Integer cdecl;
audio_ring:           function :Integer cdecl;
audio_shutup: 				function :Integer cdecl;
audio_deactivate:     function :Integer cdecl;

{$ENDIF}

function isIAXPhone: Boolean;

implementation

var
  IAXPhoneDLL : HMODULE;

function isIAXPhone: Boolean;
begin
{$IFDEF IAXSTATIC}
  Result := True;
{$ELSE}
  Result := IAXPhoneDLL <> 0;
{$ENDIF}
end;


{$IFDEF IAXSTATIC}
function pc_simple_event; external 'IAXPHONE.DLL';
function pc_send_unlink; external 'IAXPHONE.DLL';
function pc_send_link_reject; external 'IAXPHONE.DLL';
function pc_send_lagreq; external 'IAXPHONE.DLL';
function pc_transfer; external 'IAXPHONE.DLL';
function pc_onhook; external 'IAXPHONE.DLL';
function pc_offhook; external 'IAXPHONE.DLL';
function pc_load_complete; external 'IAXPHONE.DLL';
function pc_answer; external 'IAXPHONE.DLL';
function pc_ring_announce; external 'IAXPHONE.DLL';
function pc_accept; external 'IAXPHONE.DLL';
function pc_select; external 'IAXPHONE.DLL';
function pc_conference; external 'IAXPHONE.DLL';
function pc_unconference; external 'IAXPHONE.DLL';
function pc_dial_tbd; external 'IAXPHONE.DLL';
function pc_send_linked_url; external 'IAXPHONE.DLL';
function pc_dial; external 'IAXPHONE.DLL';
function pc_send_text; external 'IAXPHONE.DLL';
function pc_addr; external 'IAXPHONE.DLL';
function pc_init; external 'IAXPHONE.DLL';
function pc_write_event; external 'IAXPHONE.DLL';
function pc_read_event; external 'IAXPHONE.DLL';
function pc_send_dtmf; external 'IAXPHONE.DLL';
function pc_send_dpreq; external 'IAXPHONE.DLL';
function pc_hangup; external 'IAXPHONE.DLL';
function pc_reject; external 'IAXPHONE.DLL';
function pc_auth_reply; external 'IAXPHONE.DLL';
function pc_call; external 'IAXPHONE.DLL';
function pc_complete; external 'IAXPHONE.DLL';
function pc_register; external 'IAXPHONE.DLL';
function pc_session_new; external 'IAXPHONE.DLL';
function pc_get_fd; external 'IAXPHONE.DLL';
function pc_select_audio; external 'IAXPHONE.DLL';
function phonecore_thread; external 'IAXPHONE.DLL';
function pc_debug_callback; external 'IAXPHONE.DLL';
function sound_toapp_init; external 'IAXPHONE.DLL';
function sound_toapp_send; external 'IAXPHONE.DLL';
function audio_ringing; external 'IAXPHONE.DLL';
function audio_ring; external 'IAXPHONE.DLL';
function audio_shutup; external 'IAXPHONE.DLL';
function audio_deactivate; external 'IAXPHONE.DLL';

{$ELSE}
function IsNTandDelphiRunning : boolean;
var
  OSVersion  : TOSVersionInfo;
  AppName    : array[0..255] of char;
begin
  OSVersion.dwOsVersionInfoSize := sizeof(OSVersion);
  GetVersionEx(OSVersion);
  // Not running in NT or program is not Delphi itself ?
  AppName[0] := #0;
  lstrcat(AppName, PChar(ParamStr(0)));  // ParamStr(0) = Application.ExeName
  CharUpperBuff(AppName, SizeOf(AppName));
  result := ( (OSVersion.dwPlatformID = VER_PLATFORM_WIN32_NT) and
              (Pos('DELPHI32.EXE', AppName) = Length(AppName) - Length('DELPHI32.EXE') + 1) );
end;

initialization
begin
	if not IsNTandDelphiRunning then
  begin
    IAXPhoneDLL := LoadLibrary('IAXPHONE.DLL');

		pc_simple_event			:=	GetProcAddress(IAXPhoneDLL,'pc_simple_event');
    pc_send_unlink			:=	GetProcAddress(IAXPhoneDLL,'pc_send_unlink');
    pc_send_link_reject	:=	GetProcAddress(IAXPhoneDLL,'pc_send_link_reject');
    pc_send_lagreq			:=	GetProcAddress(IAXPhoneDLL,'pc_send_lagreq');
    pc_transfer					:=	GetProcAddress(IAXPhoneDLL,'pc_transfer');
    pc_onhook						:=	GetProcAddress(IAXPhoneDLL,'pc_onhook');
    pc_offhook					:=	GetProcAddress(IAXPhoneDLL,'pc_offhook');
    pc_load_complete		:=	GetProcAddress(IAXPhoneDLL,'pc_load_complete');
    pc_answer						:=	GetProcAddress(IAXPhoneDLL,'pc_answer');
    pc_ring_announce		:=	GetProcAddress(IAXPhoneDLL,'pc_ring_announce');
    pc_accept						:=	GetProcAddress(IAXPhoneDLL,'pc_accept');
    pc_select						:=	GetProcAddress(IAXPhoneDLL,'pc_select');
    pc_conference				:=	GetProcAddress(IAXPhoneDLL,'pc_conference');
    pc_unconference			:=	GetProcAddress(IAXPhoneDLL,'pc_unconference');
    pc_dial_tbd					:=	GetProcAddress(IAXPhoneDLL,'pc_dial_tbd');
    pc_send_linked_url	:=	GetProcAddress(IAXPhoneDLL,'pc_send_linked_url');
    pc_dial							:=	GetProcAddress(IAXPhoneDLL,'pc_dial');
    pc_send_text				:=	GetProcAddress(IAXPhoneDLL,'pc_send_text');
    pc_addr							:=	GetProcAddress(IAXPhoneDLL,'pc_addr');
    pc_init							:=	GetProcAddress(IAXPhoneDLL,'pc_init');
    pc_write_event			:=	GetProcAddress(IAXPhoneDLL,'pc_write_event');
    pc_read_event				:=	GetProcAddress(IAXPhoneDLL,'pc_read_event');
    pc_send_dtmf				:=	GetProcAddress(IAXPhoneDLL,'pc_send_dtmf');
    pc_send_dpreq				:=	GetProcAddress(IAXPhoneDLL,'pc_send_dpreq');
    pc_hangup						:=	GetProcAddress(IAXPhoneDLL,'pc_hangup');
    pc_reject						:=	GetProcAddress(IAXPhoneDLL,'pc_reject');
    pc_auth_reply				:=	GetProcAddress(IAXPhoneDLL,'pc_auth_reply');
    pc_call							:=	GetProcAddress(IAXPhoneDLL,'pc_call');
    pc_complete					:=	GetProcAddress(IAXPhoneDLL,'pc_complete');
    pc_register					:=	GetProcAddress(IAXPhoneDLL,'pc_register');
    pc_session_new			:=	GetProcAddress(IAXPhoneDLL,'pc_session_new');
    pc_get_fd						:=	GetProcAddress(IAXPhoneDLL,'pc_get_fd');
    pc_select_audio			:=	GetProcAddress(IAXPhoneDLL,'pc_select_audio');
    phonecore_thread		:=	GetProcAddress(IAXPhoneDLL,'phonecore_thread');
    pc_debug_callback		:=	GetProcAddress(IAXPhoneDLL,'pc_debug_callback');
    sound_toapp_init		:=	GetProcAddress(IAXPhoneDLL,'sound_toapp_init');
    sound_toapp_send		:=	GetProcAddress(IAXPhoneDLL,'sound_toapp_send');
  end;
end;

finalization
begin
  if IAXPhoneDLL <> 0 then FreeLibrary(IAXPhoneDLL);
end;
{$ENDIF}


end.
