/*
 * Asterisk ActiveX client
 *
 * Copyright (C) 2001-2002, Omar Carvajal
 *
 * Omar Carvajal <omar@carvajal.com>
 *
 * This program is free software, distributed under the terms of
 * the GNU General Public License
 */

// Virt1800Ctl.cpp : Implementation of the CVirt1800Ctrl ActiveX Control class.

#include "stdafx.h"
#include "virt1800.h"
#include "Virt1800Ctl.h"
#include "Virt1800Ppg.h"

#include "comcat.h"
#include "objsafe.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNCREATE(CVirt1800Ctrl, COleControl)


/////////////////////////////////////////////////////////////////////////////
// Message map

BEGIN_MESSAGE_MAP(CVirt1800Ctrl, COleControl)
	//{{AFX_MSG_MAP(CVirt1800Ctrl)
	// NOTE - ClassWizard will add and remove message map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG_MAP
	ON_OLEVERB(AFX_IDS_VERB_PROPERTIES, OnProperties)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// Dispatch map

BEGIN_DISPATCH_MAP(CVirt1800Ctrl, COleControl)
	//{{AFX_DISPATCH_MAP(CVirt1800Ctrl)
	DISP_PROPERTY_NOTIFY(CVirt1800Ctrl, "message", m_message, OnMessageChanged, VT_BSTR)
	DISP_PROPERTY_EX(CVirt1800Ctrl, "call", GetCall, SetCall, VT_BSTR)
	DISP_PROPERTY_EX(CVirt1800Ctrl, "dtmf", GetDtmf, SetDtmf, VT_BSTR)
	DISP_FUNCTION(CVirt1800Ctrl, "hangup", hangup, VT_EMPTY, VTS_NONE)
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()


/////////////////////////////////////////////////////////////////////////////
// Event map

BEGIN_EVENT_MAP(CVirt1800Ctrl, COleControl)
	//{{AFX_EVENT_MAP(CVirt1800Ctrl)
	EVENT_CUSTOM("OnMessage", FireOnMessage, VTS_NONE)
	//}}AFX_EVENT_MAP
END_EVENT_MAP()


/////////////////////////////////////////////////////////////////////////////
// Property pages

// TODO: Add more property pages as needed.  Remember to increase the count!
BEGIN_PROPPAGEIDS(CVirt1800Ctrl, 1)
	PROPPAGEID(CVirt1800PropPage::guid)
END_PROPPAGEIDS(CVirt1800Ctrl)


/////////////////////////////////////////////////////////////////////////////
// Initialize class factory and guid

IMPLEMENT_OLECREATE_EX(CVirt1800Ctrl, "VIRT1800.Virt1800Ctrl.1",
	0x31d4eae6, 0x948b, 0x11d5, 0x9d, 0x6e, 0, 0x50, 0x8b, 0x59, 0x3a, 0x27)


/////////////////////////////////////////////////////////////////////////////
// Type library ID and version

IMPLEMENT_OLETYPELIB(CVirt1800Ctrl, _tlid, _wVerMajor, _wVerMinor)


/////////////////////////////////////////////////////////////////////////////
// Interface IDs

const IID BASED_CODE IID_DVirt1800 =
		{ 0x391c6c64, 0x97b0, 0x11d5, { 0x9d, 0x6e, 0, 0x50, 0x8b, 0x59, 0x3a, 0x27 } };
const IID BASED_CODE IID_DVirt1800Events =
		{ 0x391c6c65, 0x97b0, 0x11d5, { 0x9d, 0x6e, 0, 0x50, 0x8b, 0x59, 0x3a, 0x27 } };


/////////////////////////////////////////////////////////////////////////////
// Control type information

static const DWORD BASED_CODE _dwVirt1800OleMisc =
	OLEMISC_INVISIBLEATRUNTIME |
	OLEMISC_ACTIVATEWHENVISIBLE |
	OLEMISC_SETCLIENTSITEFIRST |
	OLEMISC_INSIDEOUT |
	OLEMISC_CANTLINKINSIDE |
	OLEMISC_RECOMPOSEONRESIZE;

IMPLEMENT_OLECTLTYPE(CVirt1800Ctrl, IDS_VIRT1800, _dwVirt1800OleMisc)


////////////////////////////////////////////////////////////////
// Copied from the ActiveX SDK
// This code is used to register and unregister a
// control as safe for initialization and safe for scripting
HRESULT CreateComponentCategory(CATID catid, WCHAR* catDescription)
{
     ICatRegister* pcr = NULL ;
     HRESULT hr = S_OK ;
     hr = CoCreateInstance(CLSID_StdComponentCategoriesMgr,
            NULL, CLSCTX_INPROC_SERVER, IID_ICatRegister, (void**)&pcr);
     if (FAILED(hr))
            return hr;
     // Make sure the HKCR\Component Categories\{..catid...} 
     // key is registered
     CATEGORYINFO catinfo;
     catinfo.catid = catid;
     catinfo.lcid = 0x0409 ; // english
     // Make sure the provided description is not too long.
     // Only copy the first 127 characters if it is
     int len = wcslen(catDescription);
     if (len>127)
           len = 127;
     wcsncpy(catinfo.szDescription, catDescription, len);
     // Make sure the description is null terminated
     catinfo.szDescription[len] = '\0';
     hr = pcr->RegisterCategories(1, &catinfo);
     pcr->Release();
     return hr;
}
HRESULT RegisterCLSIDInCategory(REFCLSID clsid, CATID catid)
{
    // Register your component categories information.
    ICatRegister* pcr = NULL ;
    HRESULT hr = S_OK ;
    hr = CoCreateInstance(CLSID_StdComponentCategoriesMgr,
            NULL, CLSCTX_INPROC_SERVER, IID_ICatRegister, (void**)&pcr);
    if (SUCCEEDED(hr))
    {
           // Register this category as being "implemented" by
           // the class.
           CATID rgcatid[1] ;
           rgcatid[0] = catid;
           hr = pcr->RegisterClassImplCategories(clsid, 1, rgcatid);
    }
    if (pcr != NULL)
          pcr->Release();
    return hr;
}
HRESULT UnRegisterCLSIDInCategory(REFCLSID clsid, CATID catid)
{
    ICatRegister* pcr = NULL ;
    HRESULT hr = S_OK ;
    hr = CoCreateInstance(CLSID_StdComponentCategoriesMgr,
             NULL, CLSCTX_INPROC_SERVER, IID_ICatRegister, (void**)&pcr);
    if (SUCCEEDED(hr))
    {
        // Unregister this category as being "implemented" by
        // the class.
        CATID rgcatid[1] ;
        rgcatid[0] = catid;
        hr = pcr->UnRegisterClassImplCategories(clsid, 1, rgcatid);
    }
    if (pcr != NULL)
    pcr->Release();
    return hr;

}

/////////////////////////////////////////////////////////////////////////////
// CVirt1800Ctrl::CVirt1800CtrlFactory::UpdateRegistry -
// Adds or removes system registry entries for CVirt1800Ctrl

BOOL CVirt1800Ctrl::CVirt1800CtrlFactory::UpdateRegistry(BOOL bRegister)
{
/*	if (bRegister)
		return AfxOleRegisterControlClass(
			AfxGetInstanceHandle(),
			m_clsid,
			m_lpszProgID,
			IDS_VIRT1800,
			IDB_VIRT1800,
			afxRegApartmentThreading,
			_dwVirt1800OleMisc,
			_tlid,
			_wVerMajor,
			_wVerMinor);
	else
		return AfxOleUnregisterClass(m_clsid, m_lpszProgID);*/


	if (bRegister) {
		HRESULT hr = S_OK ;
		// register as safe for scripting
		hr = CreateComponentCategory(CATID_SafeForScripting, L"Controls that are safely scriptable");
		if (FAILED(hr))
			return FALSE;
		hr = RegisterCLSIDInCategory(m_clsid, CATID_SafeForScripting);
		if (FAILED(hr))
			return FALSE;
		// register as safe for initializing
		hr = CreateComponentCategory(CATID_SafeForInitializing, L"Controls safely initializable from persistent data");
		if (FAILED(hr))
			return FALSE;
		hr = RegisterCLSIDInCategory(m_clsid, CATID_SafeForInitializing);
		if (FAILED(hr))
			return FALSE;

		return AfxOleRegisterControlClass(
			AfxGetInstanceHandle(),
			m_clsid,
			m_lpszProgID,
			IDS_VIRT1800,
			IDB_VIRT1800,
			afxRegInsertable | afxRegApartmentThreading,
			_dwVirt1800OleMisc,
			_tlid,
			_wVerMajor,
			_wVerMinor);
	} else {
		HRESULT hr = S_OK ;
		hr = UnRegisterCLSIDInCategory(m_clsid, CATID_SafeForScripting);
		if (FAILED(hr))
			return FALSE;
		hr = UnRegisterCLSIDInCategory(m_clsid, CATID_SafeForInitializing);
		if (FAILED(hr))
			return FALSE;
		return AfxOleUnregisterClass(m_clsid, m_lpszProgID);
	}
}


/////////////////////////////////////////////////////////////////////////////
// CVirt1800Ctrl::CVirt1800Ctrl - Constructor

CVirt1800Ctrl::CVirt1800Ctrl()
{
	InitializeIIDs(&IID_DVirt1800, &IID_DVirt1800Events);

	//Reset some stuff
	answered_call = 0;
	newcall = 0;
	outqueue = NULL;
	whinserial = 1;
	nextwhin = 1;
	endcall = true;
	haddress = "";
	havecalled = false;
	//End of Reset some stuff
}


/////////////////////////////////////////////////////////////////////////////
// CVirt1800Ctrl::~CVirt1800Ctrl - Destructor

CVirt1800Ctrl::~CVirt1800Ctrl()
{
	endcall = true;
	if (havecalled == true)
		killem();
}


/////////////////////////////////////////////////////////////////////////////
// CVirt1800Ctrl::OnDraw - Drawing function

void CVirt1800Ctrl::OnDraw(
			CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid)
{
	// TODO: Replace the following code with your own drawing code.
	pdc->FillRect(rcBounds, CBrush::FromHandle((HBRUSH)GetStockObject(WHITE_BRUSH)));
	pdc->Ellipse(rcBounds);
}


/////////////////////////////////////////////////////////////////////////////
// CVirt1800Ctrl::DoPropExchange - Persistence support

void CVirt1800Ctrl::DoPropExchange(CPropExchange* pPX)
{
	ExchangeVersion(pPX, MAKELONG(_wVerMinor, _wVerMajor));
	COleControl::DoPropExchange(pPX);

	// TODO: Call PX_ functions for each persistent custom property.

}


/////////////////////////////////////////////////////////////////////////////
// CVirt1800Ctrl::OnResetState - Reset control to default state

void CVirt1800Ctrl::OnResetState()
{
	COleControl::OnResetState();  // Resets defaults found in DoPropExchange

	// TODO: Reset any other control state here.
}


//Defined Functions
int CVirt1800Ctrl::audiosetup() {   //Returns 1 on error

	/* start up the windoze-socket layer stuff */
	if (WSAStartup(0x0101,&foop)) {
		rptmesg("Fatal error: Falied to startup windows sockets");
		return 1;
	}

	/* setup the format for opening audio channels */
	wf.wFormatTag = WAVE_FORMAT_PCM;
	wf.nChannels = 1;
	wf.nSamplesPerSec = 8000;
	wf.nAvgBytesPerSec = 16000;
	wf.nBlockAlign = 2;
	wf.wBitsPerSample = 16;
	wf.cbSize = 0;

	/* open the audio out channel */
	if (waveOutOpen(&wout,0,&wf,0,0,CALLBACK_NULL) != MMSYSERR_NOERROR)
		{
			rptmesg("Fatal Error: Failed to open wave output device");
			return 1;
		}
	/* open the audio in channel */
	if (waveInOpen(&win,0,&wf,0,0,CALLBACK_NULL) != MMSYSERR_NOERROR)
		{
			rptmesg("Fatal Error: Failed to open wave input device");
			waveOutReset(wout);
			waveOutClose(wout);
			return 1;
		}
	/* activate the exit handler */
	//atexit(killem);
	/* initialize the audio in buffer structures */
	memset(&whin,0,sizeof(whin));

	return 0;
}

struct peer *CVirt1800Ctrl::find_peer(struct iax_session *session)
{
	struct peer *cur = peers;
	while(cur) {
		if (cur->session == session)
			return cur;
		cur = cur->next;
	}
	return NULL;
}

void CVirt1800Ctrl::do_iax_event(FILE *f) {
	int sessions = 0;
	struct iax_event *e = 0;
	struct peer *peer;

	while ( (e = iax_get_event(0))) {
		peer = find_peer(e->session);
		if(peer) {
			handle_event(f, e, peer);
		} else {
			if(e->etype != IAX_EVENT_CONNECT) {
				rptmesg("Huh? This is an event for a non-existant session?");
			}
			sessions++;

			if(sessions >= MAX_SESSIONS) {
				rptmesg("Missed a call... too many sessions open.");
			}


			/*if(e->event.connect.callerid && e->event.connect.dnid)
				fprintf(f, "Call from '%s' for '%s'", e->event.connect.callerid, 
				e->event.connect.dnid);
			else if(e->event.connect.dnid) {
				fprintf(f, "Call from '%s'", e->event.connect.dnid);
			} else if(e->event.connect.callerid) {
				fprintf(f, "Call from '%s'", e->event.connect.callerid);
			} else printf("Call from");
			fprintf(f, " (%s)\n", inet_ntoa(iax_get_peer_addr(e->session).sin_addr));*/

			if(most_recent_answer) {
				rptmesg("Incoming call ignored, there's already a call waiting for answer... \
please accept or reject first");
				iax_reject(e->session, "Too many calls, we're busy!");
			} else {
				if ( !(peer = (struct peer *) malloc(sizeof(struct peer)))) {
					rptmesg("Warning: Unable to allocate memory!");
					return;
				}

				peer->time = time(0);
				peer->session = e->session;
				peer->gsmin = 0;
				peer->gsmout = 0;

				peer->next = peers;
				peers = peer;

				iax_accept(peer->session);
				iax_ring_announce(peer->session);
				most_recent_answer = peer;
				//fprintf(f, "Incoming call!\n");
			}
			iax_event_free(e);
//			issue_prompt(f);
		}
	}
}

void CVirt1800Ctrl::handle_event(FILE *f, struct iax_event *e, struct peer *p)
{
	int len,n;
	WHOUT *wh,*wh1;
	short fr[160];
	static paused_xmit = 0;


	switch(e->etype) {
		case IAX_EVENT_HANGUP:
			iax_hangup(most_recent_answer->session, "Byeee!");
			rptmesg("Call disconnected by peer");
			free(most_recent_answer);
			most_recent_answer = 0;
			answered_call = 0;
			peers = 0;
			newcall = 0;
			hangup();
			
			break;

		case IAX_EVENT_REJECT:
			rptmesg("Authentication was rejected");
			break;
		case IAX_EVENT_ACCEPT:
			rptmesg("Waiting for answer...");
//			issue_prompt(f);
			break;
		case IAX_EVENT_ANSWER:
			answer_call();
 			break;
		case IAX_EVENT_VOICE:
			switch(e->event.voice.format) {
				case AST_FORMAT_GSM:
					if(e->event.voice.datalen % 33) {
						rptmesg("Weird gsm frame, not a multiple of 33.");
						break;
					}

					if (!p->gsmin)
						p->gsmin = gsm_create();

					len = 0;
					while(len < e->event.voice.datalen) {
						if(gsm_decode(p->gsmin, (unsigned char *) e->event.voice.data + len, fr)) {
							rptmesg("Bad GSM data");
							break;
						} else {  /* its an audio packet to be output to user */

							/* get count of pending items in audio output queue */
							n = 0; 
							if (outqueue) 
							{	/* determine number of pending out queue items */
								for(wh = outqueue; wh != NULL; wh = wh->next)
								{
									if (!(wh->w.dwFlags & WHDR_DONE)) n++;
								}
							}
							/* if not too many, send to user, otherwise chuck packet */
							if (n <= OUT_DEPTH) /* if not to chuck packet */
							{
								/* malloc the memory for the queue item */
								wh = (WHOUT *) malloc(sizeof(WHOUT));
								if (wh == (WHOUT *) NULL) /* if error, bail */
								{
									rptmesg("Outa memory!!!!");
									exit(255);
								}
								/* initialize the queue entry */
								memset(wh,0,sizeof(WHOUT));
								/* copy the PCM data from the gsm conversion buffer */
								memcpy((char *)wh->data,(char *)fr,sizeof(fr));
								/* set parameters for data */
								wh->w.lpData = (char *) wh->data;
								wh->w.dwBufferLength = 320;
								
								/* prepare buffer for output */
								if (waveOutPrepareHeader(wout,&wh->w,sizeof(WAVEHDR)))
								{
									rptmesg("Cannot prepare header for audio out");
									exit(255);
								}
								/* if not currently transmitting, hold off a couple of packets for 
									smooth sounding output */
								if ((!n) && (!paused_xmit))
								{
									/* pause output (before starting) */
									waveOutPause(wout);
									/* indicate as such */
									paused_xmit = 1;
								}
								/* queue packet for output on audio device */
								if (waveOutWrite(wout,&wh->w,sizeof(WAVEHDR)))
								{
									rptmesg("Cannot output to wave output device");
									exit(255);
								}
								/* if we are paused, and we have enough packets, start audio */
								if ((n > OUT_PAUSE_THRESHOLD) && paused_xmit)
								{
									/* start the output */
									waveOutRestart(wout);
									/* indicate as such */
									paused_xmit = 0;
								}
								/* insert it onto tail of outqueue */
								if (outqueue == NULL) /* if empty queue */
									outqueue = wh; /* point queue to new entry */
								else /* otherwise is non-empty queue */
								{
									wh1 = outqueue;
									while(wh1->next) wh1 = wh1->next; /* find last entry in queue */
									wh1->next = wh; /* point it to new entry */
								}
							} 
#ifdef	PRINTCHUCK
							else rptmesg("Chucking packet!!");
#endif
						}
						len += 33;
					}
					break;
				default :
					rptmesg("Don't know how to handle that format");
			}
			break;
		case IAX_EVENT_RINGA:
			break;
		default:
			rptmesg("Unknown event");
			break;
	}
}

void CVirt1800Ctrl::answer_call(void)
{
	if(most_recent_answer)
		iax_answer(most_recent_answer->session);
	//printf("Answering call!\n");
	answered_call = 1;
}

/* handle all network requests, and a pending scheduled event, if any */
void CVirt1800Ctrl::service_network(int netfd, FILE *f)
{
	fd_set readfd;
	struct timeval dumbtimer;

	/* set up a timer that falls-through */
	dumbtimer.tv_sec = 0;
	dumbtimer.tv_usec = 0;


		for(;;) /* suck everything outa network stuff */
		{
			FD_ZERO(&readfd);
			FD_SET(netfd, &readfd);
			if (select(netfd + 1, &readfd, 0, 0, &dumbtimer) > 0)
			{
				if (FD_ISSET(netfd,&readfd))
				{
					do_iax_event(f);
					(void) iax_time_to_next_event();
				} else break;
			} else break;
		}
		do_iax_event(f); /* do pending event if any */
}

void CVirt1800Ctrl::call(FILE *f, char *num)
{
	struct peer *peer;

	if(!newcall) {
		rptmesg("Calling...");
		newcall = iax_session_new();
	} else {
		rptmesg("Already attempting to call somewhere, please cancel first!");
		return;
	}

	if ( !(peer = (struct peer *) malloc(sizeof(struct peer)))) {
		rptmesg("Warning: Unable to allocate memory!");
		return;
	}

	peer->time = time(0);
	peer->session = newcall;
	peer->gsmin = 0;
	peer->gsmout = 0;

	peer->next = peers;
	peers = peer;

	most_recent_answer = peer;

	iax_call(peer->session, 0, num, NULL, 10);
}

void CVirt1800Ctrl::dump_call(void)
{
	if(most_recent_answer)
	{
		iax_hangup(most_recent_answer->session,"");
		free(most_recent_answer);
	}
	answered_call = 0;
	most_recent_answer = 0;
	answered_call = 0;
	peers = 0;
	newcall = 0;
}

void CVirt1800Ctrl::connectpbx() {
	LPCTSTR hostname;

	hostname = haddress;

	//Reset some stuff
	port = 0;
	netfd = 0;
 	c = 0;
	i = 0;
	f = NULL;
	sprintf(rcmd, "");
	//fo = NULL;
	//sprintf(foop, "");
	t = NULL;
	wh = NULL;
	wh1 = NULL;
	wh2 = NULL;
	lastouttick = 0;
	//End of Reset some stuff

	while(endcall == false) {
		/* service the network stuff */
		service_network(netfd,f);
		if (outqueue) /* if stuff in audio output queue, free it up if its available */
		{
			/* go through audio output queue */
			for(wh = outqueue,wh1 = wh2 = NULL,i = 0; wh != NULL; wh = wh->next)
			{
				service_network(netfd,f); /* service network here for better performance */
				/* if last one was removed from queue, zot it here */
				if (i && wh1)
				{ 
					free(wh1);
					wh1 = wh2;
				}
				i = 0; /* reset "last one removed" flag */
				if (wh->w.dwFlags & WHDR_DONE) /* if this one is done */
				{
					/* prepare audio header */
					if ((c = waveOutUnprepareHeader(wout,&wh->w,sizeof(WAVEHDR))) != MMSYSERR_NOERROR)
					{ 
						rptmesg("Cannot unprepare audio out header");
						exit(255);
					}
					if (wh1 != NULL) /* if there was a last one */
					{
						wh1->next = wh->next;
					} 
					if (outqueue == wh) /* is first one, so set outqueue to next one */
					{
						outqueue = wh->next;
					}
					i = 1; /* set 'to free' flag */
				}
				wh2 = wh1;	/* save old,old wh pointer */
				wh1 = wh; /* save the old wh pointer */
			}
		}
		/* go through all audio in buffers, and prepare and queue ones that are currently idle */
		for(i = 0; i < NWHIN; i++)
		{
			service_network(netfd,f); /* service network stuff here for better performance */
			if (!(whin[i].dwFlags & WHDR_PREPARED)) /* if not prepared, do so */
			{
				/* setup this input buffer header */
				memset(&whin[i],0,sizeof(WAVEHDR));
				whin[i].lpData = bufin[i];
				whin[i].dwBufferLength = 320;
				whin[i].dwUser = whinserial++; /* set 'user data' to current serial number */
				/* prepare the buffer */
				if (waveInPrepareHeader(win,&whin[i],sizeof(WAVEHDR)))
				{
					rptmesg("Unable to prepare header for input");
//					return -1;
				}
				/* add it to device (queue) */
				if (waveInAddBuffer(win,&whin[i],sizeof(WAVEHDR)))
				{
					rptmesg("Unable to prepare header for input");
//					return -1;
				}
			}
			waveInStart(win); /* start it (if not already started) */
		}
		
		if(!newcall)
			call(f, (char *) hostname);
		else
			rptmesg("Phone Answered.");
		/* do audio input stuff for buffers that have received data from audio in device already. Must
			do them in serial number order (the order in which they were originally queued). */
		if(answered_call) /* send audio only if call answered */
		{
			for(;;) /* loop until all are found */
			{
				for(i = 0; i < NWHIN; i++) /* find an available one that's the one we are looking for */
				{
					service_network(netfd,f); /* service network here for better performance */
					/* if not time to send any more, dont */
					if (GetTickCount() < (lastouttick + OUT_INTERVAL))
					{
						i = NWHIN; /* set to value that WILL exit loop */
						break;
					}
					if ((whin[i].dwUser == nextwhin) && (whin[i].dwFlags & WHDR_DONE)) { /* if audio is ready */

						/* must have read exactly 320 bytes */
						if (whin[i].dwBytesRecorded != whin[i].dwBufferLength)
						{
							rptmesg("Short audio read.");
							//fprintf(stderr,"Short audio read, got %d bytes, expected %d bytes\n", whin[i].dwBytesRecorded,
							//	whin[i].dwBufferLength);
//							return -1;
						}
						if(!most_recent_answer->gsmout)
								most_recent_answer->gsmout = gsm_create();

						service_network(netfd,f); /* service network here for better performance */
						/* encode the audio from the buffer into GSM format */
						gsm_encode(most_recent_answer->gsmout, (short *) ((char *) whin[i].lpData), fo);
						if(iax_send_voice(most_recent_answer->session,
							AST_FORMAT_GSM, (char *)fo, sizeof(gsm_frame)) == -1)
									puts("Failed to send voice!"); 
						lastouttick = GetTickCount(); /* save time of last output */

						/* unprepare (free) the header */
						waveInUnprepareHeader(win,&whin[i],sizeof(WAVEHDR));
						/* initialize the buffer */
						memset(&whin[i],0,sizeof(WAVEHDR));
						/* bump the serial number to look for the next time */
						nextwhin++;
						/* exit the loop so that we can start at lowest buffer again */
						break;
					}
				} 
				if (i >= NWHIN) break; /* if all found, get out of loop */
			}
		}

	}
	dump_call();
	rptmesg("Ready.");
}

UINT CVirt1800Ctrl::pbxthread(LPVOID pParam) {
     CVirt1800Ctrl *me = (CVirt1800Ctrl *)pParam;
     me->connectpbx();
     return 0;
}
//End of Defined Functions

/////////////////////////////////////////////////////////////////////////////
// CVirt1800Ctrl message handlers

BSTR CVirt1800Ctrl::GetCall() 
{
	return haddress.AllocSysString();
}

void CVirt1800Ctrl::SetCall(LPCTSTR lpszNewValue) 
{
	if (strlen(lpszNewValue) != 0 && endcall == true) {
		haddress = lpszNewValue;

		//Do Setup work
		/* get time of day in milliseconds, offset by tick count (see our
		gettimeofday() implementation) */
		time(&t);
		startuptime = ((t % 86400) * 1000) - GetTickCount();

		f = stdout;
		_dup2(fileno(stdout),fileno(stderr));

		if (havecalled == false)
			if (audiosetup() == 1)
				return;

		if ( (port = iax_init(0) < 0)) {
			rptmesg("Fatal error: failed to initialize iax with port");
			return;
		}

		iax_set_formats(AST_FORMAT_GSM);
		netfd = iax_get_fd();
		//End of Do Setup work

		endcall = false;
		pThread = AfxBeginThread(pbxthread, (LPVOID)this, THREAD_PRIORITY_HIGHEST, 0);   //Start

		havecalled = true;
		SetModifiedFlag();
	}
}

BSTR CVirt1800Ctrl::GetDtmf() 
{
	return extension.AllocSysString();
}

void CVirt1800Ctrl::SetDtmf(LPCTSTR lpszNewValue) 
{
	if (endcall == false) {
		extension = lpszNewValue;
		iax_send_dtmf(most_recent_answer->session, *extension);
	}

	SetModifiedFlag();
}

void CVirt1800Ctrl::hangup() 
{
	rptmesg("Hanging up...");
	endcall = true;
}

void CVirt1800Ctrl::rptmesg(LPCTSTR msg) {
	//m_message = msg;
	//FireOnMessage();
}

void CVirt1800Ctrl::OnMessageChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}
