/*
 * Asterisk ActiveX client
 *
 * Copyright (C) 2001-2002, Omar Carvajal
 *
 * Omar Carvajal <omar@carvajal.com
 *
 * This program is free software, distributed under the terms of
 * the GNU General Public License
 */

#if !defined(AFX_VIRT1800CTL_H__391C6C72_97B0_11D5_9D6E_00508B593A27__INCLUDED_)
#define AFX_VIRT1800CTL_H__391C6C72_97B0_11D5_9D6E_00508B593A27__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

//Includes
//#include <io.h>
#include <winsock.h>
#include <mmsystem.h>
#include <io.h>
#include <stdlib.h>
#include <miniphone.h>
#include <gsm.h>
#include <iax.c>
#include <md5.c>
#include <gsm_decode.c>
#include <decode.c>
#include <gsm_encode.c>
#include <code.c>
#include <short_term.c>
#include <long_term.c>
#include <gsm_create.c>
#include <rpe.c>
#include <lpc.c>
#include <preprocess.c>
#include <add.c>
#include <table.c>
//End of Include

struct peer {
	int time;
	gsm gsmin;
	gsm gsmout;

	struct iax_session *session;
	struct peer *next;
};


/* holder of the time, relative to startup in system ticks. See our
gettimeofday() implementation */
time_t	startuptime;

/* Win-doze doenst have gettimeofday(). This sux. So, what we did is
provide some gettimeofday-like functionality that works for our purposes.
In the main(), we take a sample of the system tick counter (into startuptime).
This function returns the relative time since program startup, more or less,
which is certainly good enough for our purposes. */
void gettimeofday(struct timeval *tv, struct timezone *tz)
{
	long l = startuptime + GetTickCount();

	tv->tv_sec = l / 1000;
	tv->tv_usec = (l % 1000) * 1000;
	return;
}

// Virt1800Ctl.h : Declaration of the CVirt1800Ctrl ActiveX Control class.

/////////////////////////////////////////////////////////////////////////////
// CVirt1800Ctrl : See Virt1800Ctl.cpp for implementation.

class CVirt1800Ctrl : public COleControl
{
	DECLARE_DYNCREATE(CVirt1800Ctrl)

// Constructor
public:
	CVirt1800Ctrl();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CVirt1800Ctrl)
	public:
	virtual void OnDraw(CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid);
	virtual void DoPropExchange(CPropExchange* pPX);
	virtual void OnResetState();
	//}}AFX_VIRTUAL

// Implementation
protected:
	~CVirt1800Ctrl();

	DECLARE_OLECREATE_EX(CVirt1800Ctrl)    // Class factory and guid
	DECLARE_OLETYPELIB(CVirt1800Ctrl)      // GetTypeInfo
	DECLARE_PROPPAGEIDS(CVirt1800Ctrl)     // Property page IDs
	DECLARE_OLECTLTYPE(CVirt1800Ctrl)		// Type name and misc status

// Message maps
	//{{AFX_MSG(CVirt1800Ctrl)
		// NOTE - ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

// Dispatch maps
	//{{AFX_DISPATCH(CVirt1800Ctrl)
	CString m_message;
	afx_msg void OnMessageChanged();
	afx_msg BSTR GetCall();
	afx_msg void SetCall(LPCTSTR lpszNewValue);
	afx_msg BSTR GetDtmf();
	afx_msg void SetDtmf(LPCTSTR lpszNewValue);
	afx_msg void hangup();
	//}}AFX_DISPATCH
	DECLARE_DISPATCH_MAP()

// Event maps
	//{{AFX_EVENT(CVirt1800Ctrl)
	void FireOnMessage()
		{FireEvent(eventidOnMessage,EVENT_PARAM(VTS_NONE));}
	//}}AFX_EVENT
	DECLARE_EVENT_MAP()

	//Variables
	//Definitions
	/* stuff for wave audio device */
	HWAVEOUT wout;
	HWAVEIN win;

	typedef struct whout {
		WAVEHDR w;
		short	data[160];
		struct whout *next;
	} WHOUT;

	/* parameters for audio in */
	#define	NWHIN 8				/* number of input buffer entries */
	/* NOTE the OUT_INTERVAL parameter *SHOULD* be more around 18 to 20 or so, since the packets should
	be spaced by 20 milliseconds. However, in practice, especially in Windoze-95, setting it that high
	caused underruns. 10 is just ever so slightly agressive, and the receiver has to chuck a packet
	every now and then. Thats about the way it should be to be happy. */
	#define	OUT_INTERVAL 10		/* number of ms to wait before sending more data to peer */
	/* parameters for audio out */
	#define	OUT_DEPTH 12		/* number of outbut buffer entries */
	#define	OUT_PAUSE_THRESHOLD 2 /* number of active entries needed to start output (for smoothing) */
	
	/* audio input buffer headers */
	WAVEHDR whin[NWHIN];

	struct peer *most_recent_answer;

	/* routine called at exit to shutdown audio I/O and close nicely.
	NOTE: If all this isnt done, the system doesnt not handle this
	cleanly and has to be rebooted. What a pile of doo doo!! */
	void killem(void)
	{
		waveInStop(win);
		waveInReset(win);
		waveInClose(win); 
		waveOutReset(wout);
		waveOutClose(wout);
		WSACleanup(); /* dont forget socket stuff too */
		return;
	}

	int CVirt1800Ctrl::audiosetup();
	static UINT pbxthread(LPVOID pParam);
	void CVirt1800Ctrl::connectpbx();
	void CVirt1800Ctrl::service_network(int netfd, FILE *f);
	void CVirt1800Ctrl::do_iax_event(FILE *f);
	struct peer *CVirt1800Ctrl::find_peer(struct iax_session *session);
	void CVirt1800Ctrl::handle_event(FILE *f, struct iax_event *e, struct peer *p);
	void CVirt1800Ctrl::answer_call(void);
	void CVirt1800Ctrl::call(FILE *f, char *num);
	void CVirt1800Ctrl::dump_call(void);
	void CVirt1800Ctrl::rptmesg(LPCTSTR msg);
	//End of Definitions

	int port;
	int netfd;
 	int c, i;
	FILE *f;
	char rcmd[RBUFSIZE];
	gsm_frame fo;
	WSADATA foop;
	time_t	t;
	WAVEFORMATEX wf;
	WHOUT *wh,*wh1,*wh2;
	unsigned long lastouttick;

	CString haddress;
	CWinThread *pThread;
	struct peer *peers;
	int answered_call;
	struct iax_session *newcall;
	WHOUT *outqueue;
	unsigned int whinserial,nextwhin;
	char bufin[NWHIN][320];
	bool endcall;
	bool havecalled;
	CString extension;
	//End of Variables

// Dispatch and event IDs
public:
	enum {
	//{{AFX_DISP_ID(CVirt1800Ctrl)
	dispidCall = 2L,
	dispidDtmf = 3L,
	dispidMessage = 1L,
	dispidHangup = 4L,
	eventidOnMessage = 1L,
	//}}AFX_DISP_ID
	};
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_VIRT1800CTL_H__391C6C72_97B0_11D5_9D6E_00508B593A27__INCLUDED)
