VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "SIPUA"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Const SwitchUA = "My Softswitch"

'User Part
Private mvarUserName As String
Private mvarAccount As String
Private mvarSIPAddress As String
Private mvarContact As String
Private mvarIP As String
Private mvarUserAgent As String
Private mvarExpires As Long
Private mvarSessionExpire As Long

'SIP Message Part
Private mvarHeader As String 'No Publicly Retrievable
Private mvarMethod As String
Private mvarURI As String
Private mvarVersion As String
Private mvarVia As String
Private mvarToAddr As String
Private mvarFromAddr As String
Private mvarCallID As String
Private mvarCSeq As Integer
Private mvarAccept As String
Private mvarAcceptLang As String
Private mvarAllow As String
Private mvarSupported As String
Private mvarContentType As String
Private mvarContentLength As Integer
Private mvarOptions As String

Private mvarLastMsgType As Integer
Private mvarLastMsgTypeTxt As String
'local variable(s) to hold property value(s)
Private mvarPort As Integer 'local copy
'local variable(s) to hold property value(s)
Private mvarRegistered As Boolean 'local copy
'local variable(s) to hold property value(s)
Private mvarMaxforwards As Integer 'local copy


Public Property Get Maxforwards() As Integer
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.Maxforwards
    Maxforwards = mvarMaxforwards
End Property



Sub DeleteRegistration()
 
mvarUserName = ""
mvarAccount = ""
mvarSIPAddress = ""
mvarContact = ""
mvarIP = ""
mvarUserAgent = ""
mvarExpires = 0
mvarSessionExpire = 0
mvarHeader = ""
mvarVia = ""
mvarToAddr = ""
mvarFromAddr = ""
mvarCallID = ""
mvarCSeq = 0
mvarAccept = ""
mvarAcceptLang = ""
mvarAllow = ""
mvarSupported = ""
mvarContentType = ""
mvarContentLength = 0
mvarContent = ""
mvarLastMsgType = 0
mvarLastMsgTypeTxt = ""
mvarPort = 0
mvarRegistered = False

End Sub

Public Function GetINVITE(From As Integer) As String
Dim OutMsg As String
OutMsg = "INVITE " & mvarContact & " " & mvarVersion & vbCrLf
OutMsg = OutMsg & "Via: SIP/2.0/UDP 10.50.3.10:5060" & vbCrLf
OutMsg = OutMsg & "Max-Forwards: " & (UserAgents(From).Maxforwards - 1) & vbCrLf
OutMsg = OutMsg & "From: " & UserAgents(From).FromAddr & vbCrLf
OutMsg = OutMsg & "To: " & mvarToAddr & vbCrLf
OutMsg = OutMsg & "Call-ID: " & UserAgents(From).CallID & vbCrLf
OutMsg = OutMsg & "CSeq: " & UserAgents(From).CSeq & " INVITE" & vbCrLf
OutMsg = OutMsg & "Contact: <" & UserAgents(From).Contact & ">" & vbCrLf
OutMsg = OutMsg & "User-Agent: " & UserAgents(From).UserAgent & vbCrLf
OutMsg = OutMsg & "Accept-Language: " & UserAgents(From).AcceptLang & vbCrLf
OutMsg = OutMsg & "Accept: " & UserAgents(From).Accept & vbCrLf
OutMsg = OutMsg & "Allow: " & UserAgents(From).Allow & vbCrLf
OutMsg = OutMsg & "Supported: " & UserAgents(From).Supported & vbCrLf
OutMsg = OutMsg & "Session-Expires: " & UserAgents(From).SessionExpire & vbCrLf
OutMsg = OutMsg & "Content-Type: " & UserAgents(From).ContentType & vbCrLf
OutMsg = OutMsg & "Content-Length: " & UserAgents(From).ContentLength & vbCrLf & vbCrLf
OutMsg = OutMsg & UserAgents(From).Options

GetINVITE = OutMsg
End Function

Public Property Let Registered(ByVal vData As Boolean)
mvarRegistered = vData
If mvarRegistered = False Then DeleteRegistration
End Property

Public Property Get Registered() As Boolean
Registered = mvarRegistered
End Property





Public Property Get Port() As Integer
Port = mvarPort
End Property




Private Function ProcessMsgType() As Integer
Dim lStart As Integer
Dim lEnd As Integer

mvarLastMsgTypeTxt = Left(mvarHeader, InStr(1, mvarHeader, " ") - 1)

mvarLastMsgType = 0
Select Case mvarLastMsgTypeTxt
    Case "REGISTER"
        mvarLastMsgType = sipREGISTER
    Case "INVITE"
        mvarLastMsgType = sipINVITE
    Case "SIP/2.0"
        lStart = InStr(1, mvarHeader, " ") + 1
        lEnd = InStr(lStart, mvarHeader, " ")
        mvarLastMsgType = Val(Mid(mvarHeader, lStart, lEnd - lStart))
        lStart = lEnd + 1
        lEnd = InStr(lStart, mvarHeader, vbCrLf)
        If lEnd = 0 Then lEnd = Len(mvarHeader) + 1
        mvarLastMsgTypeTxt = Mid(mvarHeader, lStart, lEnd - lStart)
End Select

ProcessMsgType = mvarLastMsgType
End Function


Public Property Get LastMsgType() As Integer
LastMsgType = mvarLastMsgType
End Property
Public Property Get LastMsgTypeTxt() As String
LastMsgTypeTxt = mvarLastMsgTypeTxt
End Property






Public Property Get Options() As String
Options = mvarOptions
End Property




Public Property Get ContentLength() As Integer
ContentLength = mvarContentLength
End Property




Public Property Get ContentType() As String
ContentType = mvarContentType
End Property



Public Property Get Supported() As String
Supported = mvarSupported
End Property




Public Property Get Allow() As String
Allow = mvarAllow
End Property



Public Property Get AcceptLang() As String
AcceptLang = mvarAcceptLang
End Property




Public Property Get Accept() As String
Accept = mvarAccept
End Property
Public Property Get Method() As String
Method = mvarMethod
End Property
Public Property Get URI() As String
URI = mvarURI
End Property
Public Property Get Version() As String
Version = mvarVersion
End Property




Public Property Get CSeq() As Integer
CSeq = mvarCSeq
End Property




Public Property Get CallID() As String
CallID = mvarCallID
End Property






Public Property Get FromAddr() As String
FromAddr = mvarFromAddr
End Property



Public Property Get TOADDR() As String
TOADDR = mvarToAddr
End Property



Public Property Get Via() As String
Via = mvarVia
End Property




Public Property Get Header() As String
Header = mvarHeader
End Property




Public Property Get SessionExpire() As Long
SessionExpire = mvarSessionExpire
End Property





Public Property Get Expires() As Long
Expires = mvarExpires
End Property


Public Property Let Expires(vData As Long)
mvarExpires = vData
End Property



Public Property Get UserAgent() As String
UserAgent = mvarUserAgent
End Property






Public Property Get IP() As String
IP = mvarIP
End Property



Public Property Get Contact() As String
Contact = mvarContact
End Property





Public Property Get SIPAddress() As String
Attribute SIPAddress.VB_UserMemId = 0
SIPAddress = mvarSIPAddress
End Property



Public Property Get Account() As String
Account = mvarAccount
End Property



Public Property Get UserName() As String
UserName = mvarUserName
End Property



Public Function GetResponse(MsgType As Integer) As String
Dim MsgOut As String
Select Case MsgType
    Case sipTRYING
        MsgOut = "SIP/2.0 100 Trying" & vbCrLf
        MsgOut = MsgOut & "Via: " & mvarVia & vbCrLf
        MsgOut = MsgOut & "From: " & mvarFromAddr & vbCrLf
        MsgOut = MsgOut & "To: " & mvarToAddr & vbCrLf
        MsgOut = MsgOut & "Call-ID: " & mvarCallID & vbCrLf
        MsgOut = MsgOut & "CSeq: " & mvarCSeq & " " & mvarLastMsgTypeTxt & vbCrLf
        MsgOut = MsgOut & "User-Agent: " & SwitchUA & vbCrLf
        MsgOut = MsgOut & "Content-Length: 0" & vbCrLf & vbCrLf
    Case sipOK
        MsgOut = "SIP/2.0 200 OK" & vbCrLf
        MsgOut = MsgOut & "Via: SIP/2.0/UDP " & mvarIP & ":" & mvarPort & vbCrLf
        MsgOut = MsgOut & "From: " & mvarFromAddr & vbCrLf
        MsgOut = MsgOut & "To: " & mvarToAddr & vbCrLf
        MsgOut = MsgOut & "Call-ID: " & mvarCallID & vbCrLf
        MsgOut = MsgOut & "CSeq: " & mvarCSeq & " INVITE" & vbCrLf
        MsgOut = MsgOut & "User-Agent: " & mvarUserAgent & vbCrLf
        MsgOut = MsgOut & "Expires: " & mvarExpires & vbCrLf
        MsgOut = MsgOut & "Contact: " & mvarContact & vbCrLf
        If mvarContentLength > 0 Then
            MsgOut = MsgOut & "Content-Length: " & mvarContentLength & vbCrLf
            MsgOut = MsgOut & vbCrLf & mvarOptions
        Else
            MsgOut = MsgOut & "Content-Length: 0" & vbCrLf
        End If
    Case sipUNAUTHORIZED
        MsgOut = "SIP/2.0 401 Unauthorized" & vbCrLf
        MsgOut = MsgOut & "Via: " & mvarVia & vbCrLf
        MsgOut = MsgOut & "From: " & mvarFromAddr & vbCrLf
        MsgOut = MsgOut & "To: " & mvarToAddr & vbCrLf
        MsgOut = MsgOut & "Call-ID: " & mvarCallID & vbCrLf
        MsgOut = MsgOut & "CSeq: " & mvarCSeq & " " & mvarLastMsgTypeTxt & vbCrLf
        MsgOut = MsgOut & "User-Agent: " & SwitchUA & vbCrLf
        MsgOut = MsgOut & "Content-Length: 0" & vbCrLf & vbCrLf
    Case sipBADREQUEST
        MsgOut = "SIP/2.0 400 Bad Request" & vbCrLf
        MsgOut = MsgOut & "Via: " & mvarVia & vbCrLf
        MsgOut = MsgOut & "From: " & mvarFromAddr & vbCrLf
        MsgOut = MsgOut & "To: " & mvarToAddr & vbCrLf
        MsgOut = MsgOut & "Call-ID: " & mvarCallID & vbCrLf
        MsgOut = MsgOut & "CSeq: " & mvarCSeq & " " & mvarLastMsgTypeTxt & vbCrLf
        MsgOut = MsgOut & "User-Agent: " & SwitchUA & vbCrLf
        MsgOut = MsgOut & "Content-Length: 0" & vbCrLf & vbCrLf
    Case sipBADREQUEST
        MsgOut = "SIP/2.0 404 Not Found " & vbCrLf
        MsgOut = MsgOut & "Via: " & mvarVia & vbCrLf
        MsgOut = MsgOut & "From: " & mvarFromAddr & vbCrLf
        MsgOut = MsgOut & "To: " & mvarToAddr & vbCrLf
        MsgOut = MsgOut & "Call-ID: " & mvarCallID & vbCrLf
        MsgOut = MsgOut & "CSeq: " & mvarCSeq & " " & mvarLastMsgTypeTxt & vbCrLf
        MsgOut = MsgOut & "User-Agent: " & SwitchUA & vbCrLf
        MsgOut = MsgOut & "Content-Length: 0" & vbCrLf & vbCrLf
    Case sipRINGING
        MsgOut = "SIP/2.0 180 Ringing" & vbCrLf
        MsgOut = MsgOut & "Via: " & mvarVia & vbCrLf
        MsgOut = MsgOut & "From: " & mvarFromAddr & vbCrLf
        MsgOut = MsgOut & "To: " & mvarToAddr & vbCrLf
        MsgOut = MsgOut & "Call-ID: " & mvarCallID & vbCrLf
        MsgOut = MsgOut & "CSeq: " & mvarCSeq & " " & mvarLastMsgTypeTxt & vbCrLf
        MsgOut = MsgOut & "Contact: " & mvarContact & vbCrLf
        MsgOut = MsgOut & "Content-Length: 0" & vbCrLf & vbCrLf
End Select
GetResponse = MsgOut
End Function

Public Sub ProcessSipMsg(txtIn As String)
Dim lStart As Integer
Dim lEnd As Integer

'Get Method
lStart = 1
lEnd = InStr(lStart, txtIn, vbCrLf)
mvarHeader = Mid(txtIn, lStart, lEnd - lStart)
If ProcessMsgType >= 100 Then
    lStart = lEnd + 1
    lEnd = InStr(lStart, txtIn, " ")
    mvarHeader = Mid(txtIn, lStart, lEnd - lStart)
Else
    lEnd = InStr(1, mvarHeader, " ")
    mvarMethod = Left(mvarHeader, lEnd - 1)
    lStart = lEnd + 1
    lEnd = InStr(lStart, mvarHeader, " ")
    mvarURI = Mid(mvarHeader, lStart, lEnd - lStart)
    lStart = lEnd + 1
    mvarVersion = Mid(mvarHeader, lStart)
End If

'Get Via
lStart = InStr(1, txtIn, "Via:")
If lStart > 0 Then
    lStart = InStr(lStart, txtIn, ": ") + 2
    lEnd = InStr(lStart, txtIn, vbCrLf)
    mvarVia = Mid(txtIn, lStart, lEnd - lStart)
    If Not Trim(mvarVia) = "" Then
        lStart = InStr(1, mvarVia, " ") + 1
        lEnd = InStr(lStart, mvarVia, ":")
        mvarIP = Mid(mvarVia, lStart, lEnd - lStart)
        lStart = lEnd + 1
        lEnd = InStr(lStart, mvarVia, ";")
        If lEnd = 0 Then lEnd = Len(mvarVia) + 1
        mvarPort = Val(Mid(mvarVia, lStart, lEnd - lStart))
    End If
End If

'Get From
lStart = InStr(1, txtIn, "From:")
If lStart > 0 Then
    lStart = InStr(lStart, txtIn, ": ") + 2
    lEnd = InStr(lStart, txtIn, vbCrLf)
    mvarFromAddr = Mid(txtIn, lStart, lEnd - lStart)
    If Not Trim(mvarFromAddr) = "" Then
        'Extract SIP Address
        lStart = InStr(1, mvarFromAddr, "<") + 1
        lEnd = InStr(lStart, mvarFromAddr, ">")
        If lEnd = 0 Then
            mvarSIPAddress = "Unknown"
        Else
            mvarSIPAddress = Mid(mvarFromAddr, lStart, lEnd - lStart)
        End If
        'Extract Username
        lStart = InStr(1, mvarFromAddr, Chr(34)) + 1
        lEnd = InStr(lStart, mvarFromAddr, Chr(34))
        If lEnd = 0 Then
            lStart = InStr(1, mvarSIPAddress, ":") + 1
            lEnd = InStr(lStart, mvarSIPAddress, "@")
            If lEnd = 0 Then lEnd = Len(mvarSIPAddress) + 1
            mvarUserName = Mid(mvarSIPAddress, lStart, lEnd - lStart)
        Else
            mvarUserName = Mid(mvarFromAddr, lStart, lEnd - lStart)
        End If
    End If
End If

'Get To
lStart = InStr(1, txtIn, "To:")
If lStart > 0 Then
    lStart = InStr(lStart, txtIn, ": ") + 2
    lEnd = InStr(lStart, txtIn, vbCrLf)
    mvarToAddr = Mid(txtIn, lStart, lEnd - lStart)
End If

'Get Call-ID
lStart = InStr(1, txtIn, "Call-ID:")
If lStart > 0 Then
    lStart = InStr(lStart, txtIn, ": ") + 2
    lEnd = InStr(lStart, txtIn, vbCrLf)
    mvarCallID = Mid(txtIn, lStart, lEnd - lStart)
End If

'Get User-Agent
lStart = InStr(1, txtIn, "User-Agent:")
If lStart > 0 Then
    lStart = InStr(lStart, txtIn, ": ") + 2
    lEnd = InStr(lStart, txtIn, vbCrLf)
    mvarUserAgent = Mid(txtIn, lStart, lEnd - lStart)
End If

'Get CSeq
lStart = InStr(1, txtIn, "CSeq:")
If lStart > 0 Then
    lStart = InStr(lStart, txtIn, ": ") + 2
    lEnd = InStr(lStart, txtIn, " ")
    mvarCSeq = Val(Mid(txtIn, lStart, lEnd - lStart))
End If

'Get Contact
lStart = InStr(1, txtIn, "Contact:")
If lStart > 0 Then
    lStart = InStr(lStart, txtIn, "<") + 1
    lEnd = InStr(lStart, txtIn, ">")
    mvarContact = Mid(txtIn, lStart, lEnd - lStart)
End If

'Get Language
lStart = InStr(1, txtIn, "Accept-Language:")
If lStart > 0 Then
    lStart = InStr(lStart, txtIn, ": ") + 2
    lEnd = InStr(lStart, txtIn, vbCrLf)
    mvarAcceptLang = Mid(txtIn, lStart, lEnd - lStart)
End If

'Get Accept
lStart = InStr(1, txtIn, "Accept:")
If lStart > 0 Then
    lStart = InStr(lStart, txtIn, ": ") + 2
    lEnd = InStr(lStart, txtIn, vbCrLf)
    mvarAccept = Mid(txtIn, lStart, lEnd - lStart)
End If

'Get Allow
lStart = InStr(1, txtIn, "Allow:")
If lStart > 0 Then
    lStart = InStr(lStart, txtIn, ": ") + 2
    lEnd = InStr(lStart, txtIn, vbCrLf)
    mvarAllow = Mid(txtIn, lStart, lEnd - lStart)
End If

'Get Supported
lStart = InStr(1, txtIn, "Supported:")
If lStart > 0 Then
    lStart = InStr(lStart, txtIn, ": ") + 2
    lEnd = InStr(lStart, txtIn, vbCrLf)
    mvarSupported = Mid(txtIn, lStart, lEnd - lStart)
End If

'Get Expires
lStart = InStr(1, txtIn, "Expires:")
If lStart > 0 Then
    lStart = InStr(lStart, txtIn, ": ") + 2
    lEnd = InStr(lStart, txtIn, " ")
    mvarExpires = Val(Mid(txtIn, lStart, lEnd - lStart))
End If

'Get Session Expires
lStart = InStr(1, txtIn, "Session-Expires:")
If lStart > 0 Then
    lStart = InStr(lStart, txtIn, ": ") + 2
    lEnd = InStr(lStart, txtIn, " ")
    mvarSessionExpire = Val(Mid(txtIn, lStart, lEnd - lStart))
End If

'Get Max Forwards
lStart = InStr(1, txtIn, "Max-Forwards:")
If lStart > 0 Then
    lStart = InStr(lStart, txtIn, ": ") + 2
    lEnd = InStr(lStart, txtIn, " ")
    mvarMaxforwards = Val(Mid(txtIn, lStart, lEnd - lStart))
End If

'Get Content-Type
lStart = InStr(1, txtIn, "Content-Type:")
If lStart > 0 Then
    lStart = InStr(lStart, txtIn, ": ") + 2
    lEnd = InStr(lStart, txtIn, vbCrLf)
    mvarContentType = Mid(txtIn, lStart, lEnd - lStart)
End If

'Get Content-Length
lStart = InStr(1, txtIn, "Content-Length:")
If lStart > 0 Then
    lStart = InStr(lStart, txtIn, ": ") + 2
    lEnd = InStr(lStart, txtIn, vbCrLf)
    mvarContentLength = Val(Mid(txtIn, lStart, lEnd - lStart))
    'Get Options from content
    If mvarContentLength > 0 Then
        lStart = InStr(lEnd + 2, txtIn, vbCrLf) + 2
        mvarOptions = Mid(txtIn, lStart, mvarContentLength)
    End If
End If


End Sub
