Attribute VB_Name = "sipGlobals"
Public Type SckInfo
    Contact As String
    Address As String
    Port As Integer
End Type

Public Type SIP_PVT
    SipID As Integer
    Registered As Boolean
    CallID As String
    CSeq As Integer             'Current sequence no.
    Expirey As Integer          'Expire time
    Branch As Integer           'Random number
    Tag As Integer              'Random number
    Cleanup As Boolean
    Src As SckInfo              'Who sent it (our peer)
    Dst As SckInfo
    Username As String
    Contact As String
    Dir As Integer
End Type

Type SI
    IP As String
    Port As Integer
End Type

Global DefaultGW As String
Global CurrentLogLevel As Integer

'Logging Levels
Public Const LOG_ERR = 1
Public Const LOG_INFO = 2
Public Const LOG_DEBUG = 3
Public Const LOG_DEBUGV = 4

'Request Types
Public Const sipREGISTER = 1
Public Const sipINVITE = 2
Public Const sipACK = 3
Public Const sipCANCEL = 4
Public Const sipBYE = 5
Public Const sipOPTIONS = 6

'Response Types
Public Const sipTRYING = 100
Public Const sipRINGING = 180
Public Const sipOK = 200
Public Const sipBADREQUEST = 400
Public Const sipUNAUTHORIZED = 401
Public Const sipNOTFOUND = 404

Public SckInfo As SI
Public SipStats As New SIP_STATS

Public SipDest(1 To 100) As SIP_PVT

Function AddHeader(msg As String, FN As String, dta As String) As String
If dta = "" Then
    AddHeader = msg
Else
    If Not Right(msg, 2) = vbCrLf Then msg = msg & vbCrLf
    AddHeader = msg & Trim(FN) & ": " & Trim(dta) & vbCrLf
End If
End Function


Function CallInfo(p As SIP_PVT) As String
Dim tmp As String

tmp = "Call-ID: " & p.CallID & vbCrLf
tmp = tmp & "Caller ID: " & p.Contact & vbCrLf
tmp = tmp & "Username: " & p.Username & vbCrLf
tmp = tmp & "CSeq: " & p.CSeq & vbCrLf
tmp = tmp & "Dst: " & p.Dst.Contact & vbCrLf
tmp = tmp & "Src Address: " & p.Src.Address & vbCrLf
tmp = tmp & "Src Port: " & p.Src.Port & vbCrLf

CallInfo = tmp
End Function

Function CheckRegistration(p As SIP_PVT) As Boolean

For I = LBound(SipDest) To UBound(SipDest)
    If SipDest(I).Contact = DitchBraces(p.Contact) Then
        CheckRegistration = True
        Exit For
    End If
Next I

End Function

Function DitchBraces(dta As String) As String
Dim lStart As Integer
Dim lEnd As Integer

lStart = InStr(1, dta, "<")

If lStart > 0 Then
    lStart = lStart + 1
    lEnd = InStr(1, dta, ">")
    If lEnd <= 0 Then lEnd = Len(dta)
    dta = Mid(dta, lStart, lEnd - lStart)
    dta = Left(dta, lEnd)
End If
DitchBraces = dta
End Function

Function GetContent(req As String) As String
Dim ContentLength As Integer
Dim lStart As Integer

ContentLength = Val(GetHeader(req, "Content-Length"))

lStart = InStr(1, req, vbCrLf & vbCrLf) + 4

GetContent = Mid(req, lStart)

End Function

Function GetCSeqTxt(req As String) As String
Dim tmp As String

tmp = GetHeader(req, "CSeq")
tmp = Mid(tmp, InStr(1, tmp, " ") + 1)

GetCSeqTxt = tmp
End Function

Function GetResponseTxt(req) As String
Dim tmp As String

If Not Left(req, 7) = "SIP/2.0" Then Exit Function

tmp = Mid(req, InStr(1, req, " ") + 1)
tmp = Mid(tmp, 1, InStr(1, tmp, vbCrLf) - 1)
GetResponseTxt = tmp

End Function

Function GetRouteHeader(req As String) As String
Dim tmp As String

tmp = GetHeader(req, "To")
tmp = DitchBraces(tmp)
If Not Right(tmp, 1) = ";" Then tmp = tmp & ";"
tmp = "<" & tmp & "maddr=" & SckInfo.IP & ">"

GetRouteHeader = tmp
End Function

Sub HandleRequest(p As SIP_PVT, req As String, sck As SckInfo)
Dim CurrentUA As Integer
Dim tmp As String

cmd = Left(req, InStr(1, req, " ") - 1)

Select Case cmd
    Case "REGISTER"
        Call logevent(LOG_DEBUG, "REGISTER request from '" & sck.Address & ":" & sck.Port & "'")
        If RegisterVerify(p, req, sck) Then
            Call SendResponse(p, "200 OK", req)
        Else
            Call SendResponse(p, "401 Unauthorised", req)
            Call logevent(LOG_INFO, "Registration failed for '" & p.Username & "' at '" & sck.Address & ":" & sck.Port & "'")
            p.Cleanup = True
        End If
    Case "INVITE"
        Dim CurRoute As String
        Call logevent(LOG_DEBUG, "Using latest request as basis request")
        p.Expirey = Val(GetHeader(req, "Session-Expires"))
        If p.Expirey = 0 Then p.Expirey = 7200
        If Not RegisterVerify(p, req, sck) Then Exit Sub
        
        Call logevent(LOG_INFO, "Call started")
        SipStats.CallAttempts = SipStats.CallAttempts + 1
        
        Call SendResponse(p, "100 Trying", req)
        CurRoute = FindRoute(p, req)
        
        If CurRoute = "" Then
            Call SendResponse(p, "404 Not Found", req)
            SipStats.FailedCalls = SipStats.FailedCalls + 1
        Else
            p.Dst.Address = GetIPFromContact(CurRoute)
            p.Dst.Port = GetPortFromContact(CurRoute)
            p.Dst.Contact = CurRoute
            
            SipDest(p.SipID) = p
            
            p.Dir = 1
            Call SendRequest(p, "INVITE", req)
        End If
    Case "CANCEL"
        Call logevent(LOG_DEBUG, "Received 'CANCEL' from " & sck.Address & ":" & sck.Port)
        If p.Src.Address = sck.Address Then
            p.Dir = 0
            Call SendResponse(p, "100 Trying", req)
            p.Dir = 1
            Call SendRequest(p, "CANCEL", req)
        Else
            p.Dir = 1
            Call SendResponse(p, "100 Trying", req)
            p.Dir = 0
            Call SendRequest(p, "CANCEL", req)
        End If
    Case "ACK"
        Call logevent(LOG_DEBUG, "Received 'ACK' from " & sck.Address & ":" & sck.Port)
        If Not p.Dst.Contact = "" And p.Src.Address = sck.Address Then
            p.Dir = 1
            Call SendRequest(p, "ACK", req)
        End If
        If SipDest(p.SipID).Cleanup Then CleanupCall p.SipID
    Case "BYE"
        Call logevent(LOG_DEBUG, "Received 'BYE' from " & p.Src.Address & ":" & p.Src.Port)
        If p.Src.Address = sck.Address Then
            p.Dir = 0
            Call SendResponse(p, "100 Trying", req)
            p.Dir = 1
            Call SendRequest(p, "BYE", req)
        Else
            p.Dir = 1
            Call SendResponse(p, "100 Trying", req)
            p.Dir = 0
            Call SendRequest(p, "BYE", req)
        End If
    Case "OPTIONS"
        'Dunno what this is, just reply OK and it shuts up.
        Call logevent(LOG_DEBUG, "Received 'OPTIONS' from " & sck.Address & ":" & sck.Port)
        p.Dir = 0
        Call SendResponse(p, "200 OK", req)
    Case "SIP/2.0"
        Dim resp As String
        resp = GetResponseTxt(req)
        If Val(resp) < 100 Then
            Call logevent(LOG_ERR, "Invalid response: " & resp)
        Else
            Call HandleResponse(p, resp, req, sck)
        End If
    Case Else
        Call logevent(LOG_ERR, "Dunno how to handle '" & cmd & "' request from " & sck.Address & ":" & sck.Port & ".")
        Call SendResponse(p, "405 Method not allowed", req)
End Select
End Sub
Public Sub CleanupCall(p As Integer)
Call logevent(LOG_DEBUG, "Cleaning up call: " & p)
With SipDest(p)
    .Branch = 0
    .CallID = ""
    .Cleanup = False
    .Contact = ""
    .CSeq = 0
    .Dir = 0
    .Dst.Address = ""
    .Dst.Contact = ""
    .Dst.Port = 0
    .Expirey = 0
    .Registered = False
    .SipID = 0
    .Src.Address = ""
    .Src.Contact = ""
    .Src.Port = 0
    .Tag = 0
    .Username = ""
End With
End Sub


Function FindCall(req As String, sck As SckInfo) As SIP_PVT
Dim CallID As String

CallID = GetHeader(req, "Call-ID")
If Len(CallID) = 0 Then
    Call logevent(LOG_ERR, "Call missing call ID from " & sck.Address)
    Exit Function
End If

'Try and find the call and return it's info
For I = LBound(SipDest) To UBound(SipDest)
    If SipDest(I).CallID = CallID Then
        FindCall = SipDest(I)
        Exit For
    End If
Next I

'If not, create a new call.
If FindCall.CallID = "" Then
    FindCall = SipAlloc(CallID, sck)
    FindCall.Contact = GetHeader(req, "Contact")
End If

End Function
Function GetHeader(req As String, Hdr As String) As String
Dim lStart As Integer
Dim lEnd As Integer
Dim Header As String

Hdr = Trim(Hdr)
If Not Right(Hdr, 1) = ":" Then Hdr = Hdr & ":"

lStart = InStr(1, req, Hdr)
If lStart = 0 Then Exit Function
lEnd = InStr(lStart, req, vbCrLf)

If lStart > 0 And lEnd > lStart Then
    Header = Mid(req, lStart, lEnd - lStart)
    Header = Replace(Header, Hdr & " ", "")
Else
    Header = ""
End If
GetHeader = Trim(Header)

End Function

Sub HandleResponse(p As SIP_PVT, resp As String, req As String, sck As SckInfo)
Dim tmp As String
Dim RespID As Integer

RespID = Val(resp)

Call logevent(LOG_DEBUG, "Got '" & resp & "' from '" & sck.Address & ":" & sck.Port & "'")

Select Case RespID
    Case 100
        'Yay! It's 'trying'!  Who gives a shit, just do it fuckya.
    Case 180
        p.Dir = 0
        Call SendResponse(p, "180 Ringing", req)
    Case 183
        Call SendResponse(p, "183 Session Progress", req)
    Case 200
        If Not p.Dst.Contact = "" Then
            If p.Src.Address = sck.Address Then
                p.Dir = 1
            Else
                p.Dir = 0
            End If
            Call SendResponse(p, "200 OK", req)
            'If this is an OK from a BYE session, clean up the call by removing the
            'association with the destination.
            tmp = GetCSeqTxt(req)
            Select Case tmp
                Case "BYE", "CANCEL"
                    SipDest(p.SipID).Cleanup = True
                    Call logevent(LOG_INFO, "Call completed")
                    SipStats.CompletedCalls = SipStats.CompletedCalls + 1
            End Select
        Else
            Call SendRequest(p, "ACK", req)
        End If
    Case 404
        If Not p.Dst.Contact = "" Then
            If p.Src.Address = sck.Address Then
                p.Dir = 1
            Else
                p.Dir = 0
            End If
            Call SendResponse(p, "404 Not Found", req)
            SipStats.FailedCalls = SipStats.FailedCalls + 1
        End If
    Case 486
        p.Dir = 0
        Call SendResponse(p, "486 Busy Here", req)
    Case 487
        Call SendResponse(p, "200 OK", req)
    Case Else
        Call logevent(LOG_DEBUG, "Dunno how to handle response #" & RespID & " '" & resp & "' from '" & p.Src.Address & ":" & p.Src.Port & "' - Forwarding")
        'Just forward everything else between the two.
        If p.Src.Address = sck.Address Then
            p.Dir = 1
        Else
            p.Dir = 0
        End If
        Call SendResponse(p, resp, req)
End Select
End Sub

Function RegisterVerify(p As SIP_PVT, dta As String, sck As SckInfo) As Boolean
Dim tmp As String
Dim lEnd As Integer

tmp = GetHeader(dta, "From")
'Ditch braces
tmp = DitchBraces(tmp)

p.Src = sck

If InStr(1, tmp, "sip:") = 0 Then
    Call logevent(LOG_ERR, "Invalid to address: " & tmp & " from " & sck.Address)
    RegisterVerify = False
    Exit Function
End If

If CheckRegistration(p) = False Then
    lEnd = InStr(1, tmp, "@")
    If lEnd = 0 Then
        p.Username = Mid(tmp, 5)
    Else
        p.Username = Mid(tmp, 5, lEnd - 5)
    End If
    p.CSeq = Val(GetHeader(dta, "CSeq"))
    p.Expirey = Val(GetHeader(dta, "Expires"))
    p.Contact = GetHeader(dta, "Contact")
    p.Src.Address = GetIPFromContact(p.Contact)
    p.Src.Port = GetPortFromContact(p.Contact)
    p.Registered = True

    AddNewLocation p, dta
    
    SipDest(p.SipID) = p

    Call logevent(LOG_INFO, "User '" & p.Username & "' successfully registered at '" & p.Src.Address & ":" & p.Src.Port & "' with ID: " & p.SipID)
    SipStats.Registrations = SipStats.Registrations + 1
Else
    p.CSeq = Val(GetHeader(dta, "CSeq"))
    If Not p.Contact = "" Then
        p.Src.Contact = p.Contact
        p.Src.Address = GetIPFromContact(p.Contact)
        p.Src.Port = GetPortFromContact(p.Contact)
    Else
        p.Src.Address = sck.Address
        p.Src.Port = sck.Port
    End If
End If

SipDest(p.SipID).Expirey = Val(GetHeader(dta, "Expires"))

RegisterVerify = True
End Function

Sub SendData(dta As String, IP As String, Port As Integer)

Call logevent(LOG_DEBUGV, "SIP Send: IP=" & IP & " Port=" & Port & vbCrLf & dta)

With frmMain.wsck
    .RemoteHost = IP
    .RemotePort = Port
    .SendData dta
End With
End Sub

Sub SendRequest(p As SIP_PVT, msg As String, req As String)
Dim reqTxt As String
Dim IP As String
Dim Port As Integer

If p.Dir = 1 Then
    IP = p.Dst.Address
    Port = p.Dst.Port
Else
    IP = p.Src.Address
    Port = p.Src.Port
End If

Call logevent(LOG_DEBUG, "Sending '" & msg & "' request to: " & IP & ":" & Port)

reqTxt = msg & " sip:" & p.Dst.Contact & " SIP/2.0"
reqTxt = AddHeader(reqTxt, "Via", "SIP/2.0/UDP " & SckInfo.IP & ":" & SckInfo.Port)
reqTxt = AddHeader(reqTxt, "Record-Route", GetRouteHeader(req))
reqTxt = AddHeader(reqTxt, "From", GetHeader(req, "From"))
reqTxt = AddHeader(reqTxt, "To", GetHeader(req, "To"))
reqTxt = AddHeader(reqTxt, "Call-ID", GetHeader(req, "Call-ID"))
reqTxt = AddHeader(reqTxt, "CSeq", GetHeader(req, "CSeq"))
reqTxt = AddHeader(reqTxt, "Contact", GetHeader(req, "Contact"))
reqTxt = AddHeader(reqTxt, "User-Agent", GetHeader(req, "User-Agent"))
reqTxt = AddHeader(reqTxt, "Accept-Language", GetHeader(req, "Accept-Language"))
reqTxt = AddHeader(reqTxt, "Accept", GetHeader(req, "Accept"))
reqTxt = AddHeader(reqTxt, "Allow", GetHeader(req, "Allow"))
reqTxt = AddHeader(reqTxt, "Supported", GetHeader(req, "Supported"))
reqTxt = AddHeader(reqTxt, "Session-Expires", GetHeader(req, "Session-Expires"))
reqTxt = AddHeader(reqTxt, "Content-Type", GetHeader(req, "Content-Type"))
reqTxt = AddHeader(reqTxt, "Content-Length", GetHeader(req, "Content-Length"))
reqTxt = reqTxt & vbCrLf & GetContent(req)

SendData reqTxt, IP, Port
End Sub
Sub SendResponse(p As SIP_PVT, txtResp As String, req As String)
Dim IP As String
Dim Port As Integer
Dim resp As String
Dim RespID As Integer

RespID = Val(Left(txtResp, 3))

resp = "SIP/2.0 " & txtResp & vbCrLf
resp = AddHeader(resp, "Via", GetHeader(req, "Via"))
resp = AddHeader(resp, "From", GetHeader(req, "From"))
resp = AddHeader(resp, "To", GetHeader(req, "To"))
resp = AddHeader(resp, "Call-ID", GetHeader(req, "Call-ID"))
resp = AddHeader(resp, "Record-Route", GetHeader(req, "Record-Route"))
resp = AddHeader(resp, "CSeq", GetHeader(req, "CSeq"))
resp = AddHeader(resp, "User-Agent", GetHeader(req, "User-Agent"))

Select Case RespID
    Case 100 To 199
        resp = AddHeader(resp, "Contact", GetHeader(req, "Contact"))
        If p.Expirey > 0 Then
            resp = AddHeader(resp, "Expires", GetHeader(req, "Expires"))
        End If
    Case 200 To 299
        If GetCSeqTxt(req) = "INVITE" Then
            resp = AddHeader(resp, "Content-Type", GetHeader(req, "Content-Type"))
            resp = AddHeader(resp, "Content-Length", GetHeader(req, "Content-Length"))
            resp = resp & vbCrLf & GetContent(req)
        Else
            resp = resp & vbCrLf
        End If
End Select


If Not Left(txtResp, 3) = "100" Then
End If

If p.Dir = 0 Then
    IP = p.Src.Address
    Port = p.Src.Port
ElseIf p.Dir = 1 Then
    IP = p.Dst.Address
    Port = p.Dst.Port
End If

Call logevent(LOG_DEBUG, "Sending '" & txtResp & "' to " & IP & ":" & Port)
SendData resp, IP, Port
End Sub

Function SipAlloc(CallID, sck As SckInfo) As SIP_PVT
For I = LBound(SipDest) To UBound(SipDest)
    If SipDest(I).CallID = "" Then
        SipDest(I).CallID = CallID
        SipDest(I).SipID = I
        SipAlloc = SipDest(I)
        Exit For
    End If
Next I
End Function


