Attribute VB_Name = "modRoutes"
Type RROUTE
    Route As String
    Contact As String
End Type

Public RouteMap(10) As RROUTE


Sub AddNewLocation(p As SIP_PVT, req As String)
'Search for existing route
For i = LBound(RouteMap) To UBound(RouteMap)
    If RouteMap(i).Contact = p.Contact Then
        Exit Sub
    End If
Next i
Dim tmp As String
tmp = ParseRoute(GetHeader(req, "From"))
Call logevent(LOG_DEBUG, "Add route '" & tmp & "' to " & p.Contact)
For i = LBound(RouteMap) To UBound(RouteMap)
    If RouteMap(i).Contact = "" Then
        RouteMap(i).Contact = p.Contact
        RouteMap(i).Route = tmp
        Exit Sub
    End If
Next i

End Sub
Public Function FindRoute(p As SIP_PVT, req As String) As String
'This function uses a digit string that is passed to it to find
'a destination contact, or sip address.

'For now, just return the one destination
Dim DG As String

DG = GetHeader(req, "To")
If InStr(1, DG, "sip:") Then DG = ParseRoute(DG)

Call logevent(LOG_INFO, "Looking for destination for: " & DG)
SipStats.LastRoute = DG

For i = LBound(RouteMap) To UBound(RouteMap)
    If RouteMap(i).Route = DG Then
        FindRoute = RouteMap(i).Contact
        Exit For
    End If
Next i

'Send to gateway if not found and longer than 6 digits
If FindRoute = "" And Len(DG) > 6 Then
    FindRoute = "<sip:" & DG & "@" & DefaultGW & ">"
ElseIf FindRoute = "" Then
    Call logevent(LOG_INFO, "No route for: " & DG)
End If


End Function


Function GetIPFromContact(Contact As String) As String
Dim NC As String
Dim lEnd As Integer

NC = DitchBraces(Contact)

If Left(NC, 4) = "sip:" Then
    NC = Replace(NC, "sip:", "")
    NC = Mid(NC, InStr(1, NC, "@") + 1)
    lEnd = InStr(1, NC, ":")
    If lEnd = 0 Then lEnd = Len(NC) + 1
    NC = Left(NC, lEnd - 1)
    GetIPFromContact = NC
Else
    GetIPFromContact = ""
End If
End Function

Function GetPortFromContact(Contact As String) As String
Dim NC As String
Dim lEnd As Integer

NC = DitchBraces(Contact)

If Left(NC, 4) = "sip:" Then
    NC = Replace(NC, "sip:", "")
    NC = Mid(NC, InStr(1, NC, ":") + 1)
    lEnd = InStr(1, NC, ";")
    If lEnd = 0 Then
        lEnd = Len(NC)
    Else
        NC = Mid(NC, 1, lEnd - 1)
    End If
    GetPortFromContact = NC
Else
    GetPortFromContact = ""
End If
End Function

Public Function ParseRoute(TOADDR As String) As String
'This functions parses the destination in the To: field.
Dim lStart As Integer
Dim lEnd As Integer

lStart = InStr(1, TOADDR, ":") + 1
lEnd = InStr(lStart, TOADDR, "@")

ParseRoute = Mid(TOADDR, lStart, lEnd - lStart)

End Function


Sub RemoveLocation(p As SIP_PVT)
Call logevent(LOG_DEBUG, "Removing routes to " & p.Contact)
For i = LBound(RouteMap) To UBound(RouteMap)
    If RouteMap(i).Contact = p.Contact Then
        RouteMap(i).Route = ""
        RouteMap(i).Contact = ""
    End If
Next i
End Sub


