#==========================================================
# astman.tcl
# A Tcl interface to the Asterisk manager commands
# Helps keep shadydial clean
# Copyleft 2003, Under the GPL
# by Chris Maj <cmaj@freedomcorpse.info>
#==========================================================

package provide AstMan 0.1

namespace eval AstMan {
    variable sock
    variable buff ""
    variable slimtalk 0
    variable slimwait 0
    variable slimlogg 0
    variable custconn 0
    variable custwait 0
    variable calls [list]
    variable emptybufflines 0
    variable ohmyebl 0
}


# set internal variables accordingly
proc ::AstMan::gobble {line} {
    variable slimtalk
    variable slimwait
    variable slimlogg
    variable custconn
    variable custwait
    variable buff
    variable calls
    variable emptybufflines

    append buff [string trim $line] " "
    # did we get a new line
    if {[string length [string trim $line]]==0} {
        # now we must have received an event or something
        set evt [string trim $buff]
        set buff ""
        set mevent ""
        set mchannel ""
        set mcontext ""
        set mextension ""
        set mpriority ""
        set mstate ""
        set mcallerid ""
        set mqueue ""
        set magents ""
        set magent ""
        set mcallers ""
        set mwaiting ""
        set mtalking ""
        set munknown ""
        # lets look at a line at a time
        set ln [split $evt]
        for {set i 0} {$i<[llength $ln]} {incr i} {
            set lcmd [string trimright [string trim [lindex $ln $i]] :]
            incr i
            set rcmd [string trim [lindex $ln $i]]
        set fd [open /tmp/shadydial.log a]
        puts $fd "$i :: $lcmd :: $rcmd ::"
        close $fd
            switch $lcmd {
                Event {set mevent $rcmd}
                Channel {set mchannel $rcmd}
                Context {set mcontext $rcmd}
                Extension {set mextension $rcmd}
                Priority {set mpriority $rcmd}
                State {set mstate $rcmd}
                Callerid {set mcallerid $rcmd}
                Queue {set mqueue $rcmd}
                Agents {set magents $rcmd}
                Agent {set magent $rcmd}
                Callers {set mcallers $rcmd}
                Waiting {set mwaiting $rcmd}
                Talking {set mtalking $rcmd}
                default {set munknown $lcmd}
            }
        }
        # now we can figure out what internal variables to set
        if {[string match "shadydial" $mcontext]} {
            if {[string match "Hangup" $mevent]} {
                # incr custconn -1
                set matched [lsearch $calls $mcallerid]
                if {$matched!=-1} {
                    set calls [lreplace $calls $matched $matched]
                    set custconn [llength $calls]
                }
            } else {
                # incr custconn
            }
        }
        if {[string match "slimagentq" $mqueue]} {
            set custwait $mcallers
        }
        if {[string match "Newstate" $mevent]} {
            if {[string match "Down" $mstate] || [string match "Up" $mstate]} {
                set matched [lsearch $calls $mcallerid]
                if {$matched!=-1} {
                    set calls [lreplace $calls $matched $matched]
                    set custconn [llength $calls]
                }
            }
        }
        if {$magents!=""} {
            # set slimlogg [expr {round(floor(double($magents)/4.0))}]
            set slimlogg [expr {$mwaiting+$mtalking}]
        }
        if {$mwaiting!=""} {
            set slimwait $mwaiting
        }
        if {$mtalking!=""} {
            set slimtalk $mtalking
        }
    } else {
        # keep track of how many empty buffer lines we got
        incr emptybufflines
    }
}


proc ::AstMan::login {host port user pass} {
    variable sock
    set res 0
    if {![catch {set sock [socket $host $port]}]} {
        after 1000
        fconfigure $sock -translation crlf
        fconfigure $sock -blocking 0
        set connstr "Action: Login
Username: $user
Secret: $pass
"
        puts $sock $connstr
        flush $sock
        after 1000
        # get the "Asterisk Call Manager" line and drop it
        gets $sock
        # get the Response line
        set success [gets $sock]
        if {[string match $success "Response: Success"]} {
            set res 1
        }
    }
    return $res
}


proc ::AstMan::logoff {} {
    variable sock
    set connstr "Action: Logoff
"
    puts $sock $connstr
    flush $sock
    close $sock
    return 1
}


proc ::AstMan::originate {tech grp phone exten context priority timeout callerid} {
    variable sock
    variable custconn
    variable calls
    set chanstr [join [list $tech $grp $phone] "/"]
    set connstr "Action: Originate
Channel: $chanstr
Exten: $exten
Context: $context
Priority: $priority
Timeout: $timeout
CallerID: $callerid
"
    puts $sock $connstr
    flush $sock
    # keep our internal variables current
    lappend calls $callerid
    set custconn [llength $calls]
    return 1
}


proc ::AstMan::showagentshort {} {
    variable sock
    set connstr "Action: ShowAgentsShort
"
    puts $sock $connstr
    flush $sock
    return 1
}


proc ::AstMan::showqueues {} {
    variable sock
    set connstr "Action: Queues
"
    puts $sock $connstr
    flush $sock
    return 1
}


proc ::AstMan::queuestatus {} {
    variable sock
    set connstr "Action: QueueStatus
"
    puts $sock $connstr
    flush $sock
    return 1
}


proc ::AstMan::showagentqueues {} {
    variable sock
    set connstr "Action: AgentQueues
"
    puts $sock $connstr
    flush $sock
    return 1
}


