#==========================================================
# ShadyDial
# A predictive dialer for Asterisk
# Copyleft 2003, Under the GPL
# by Chris Maj <cmaj@freedomcorpse.info>
#==========================================================
source /usr/local/bin/astman.tcl
source /usr/local/bin/pgin.tcl
package require AstMan
package require Tclx

# this is the database login stuff you need to change
set shady_pg_host "HOSTNAME"
set shady_pg_port "5432"
set shady_pg_dbname "DATABASE"
set shady_pg_user "USERNAME"
set shady_pg_password "PASSWORD"

# this is the asterisk manager login stuff you need to change
set shady_ast_host "HOSTNAME"
set shady_ast_port "5038"
set shady_ast_user "USERNAME"
set shady_ast_password "PASSWORD"

proc shutdown {} {
    global pgc
    pg_disconnect $pgc
    exit
}

proc logindb {} {
    global pgc
    set ohmyebl -1
    set connres [catch {set pgc [pg_connect -conninfo "host=$shady_pg_host port=$shady_pg_port dbname=$shady_pg_dbname user=$shady_pg_user password=$shady_pg_password"]}]
    if {$connres} {
        set fd [open /tmp/shadydial.log a]
        puts $fd "COULD NOT LOG INTO $shady_pg_host: [clock format [clock seconds]]"
        close $fd
        shutdown
    }
}

# place calls if needed
# get into an infinite loop
proc dispatcher {} {
    global stallcnt
    global pgc
    set ph ""
    set phl [list]
    set phsql ""
    set pace ""
    # see if any agent is waiting for a call
    ::AstMan::showagentqueues
    ::AstMan::showagentshort
    #::AstMan::showqueues
    #::AstMan::queuestatus
    #::AstMan::slimagents
    set fd [open /tmp/shadydial.log a]
    puts $fd "slimtalk: $::AstMan::slimtalk slimwait: $::AstMan::slimwait slimlogg: $::AstMan::slimlogg custwait: $::AstMan::custwait custconn: $::AstMan::custconn sock: $::AstMan::sock emptybufflines: $::AstMan::emptybufflines"
    puts $fd [join $::AstMan::calls]
    flush $fd
    close $fd
    # this lines gory too
    if {$::AstMan::slimtalk==0 \
        && $::AstMan::custconn==0 \
        && $::AstMan::custwait==0 \
        && $::AstMan::slimlogg>0 \
        && $::AstMan::slimwait==0} {
        set ::AstMan::slimwait $::AstMan::slimlogg
    }
    # this line right below is gory
    if {$::AstMan::custconn < 0} {set ::AstMan::custconn 0}
    if {$::AstMan::slimlogg > 0 && $::AstMan::custwait == 0} {
        logindb
        # ok agents are waiting so we need to start calling
        set sql "SELECT * FROM vw_shadydial_bunch_o_nums;"
        if {[catch {
            pg_select $pgc $sql rec {
                lappend phl $rec(phone)
            }
        } gterrmsg]} {
            set fd [open /tmp/shadydial.log a]
            puts $fd "ERROR! $gterrmsg"
            flush $fd
            close $fd
        }
        # make sure we make at least one phone call
        set phl [lrange $phl 0 $::AstMan::slimwait]
        set phsql "('"
        append phsql [join $phl "','"]
        append phsql "')"
        set sql "UPDATE shadydial_phonebook SET last_called=current_timestamp WHERE phone IN $phsql;"
        pg_exec $pgc $sql
        set sql "SELECT shadydial_get_call_pace() * shadydial_get_speed() AS speed_pace;"
        if {[catch {
            pg_select $pgc $sql rec {
                set pace $rec(speed_pace)
            }
        } gterrmsg]} {
            set fd [open /tmp/shadydial.log a]
            puts $fd "ERROR! $gterrmsg"
            flush $fd
            close $fd
        }
        set fd [open /tmp/shadydial.log a]
        foreach ph $phl {
            puts $fd "CALLED: $ph"
            # dont call after 9 or before 9 - no matter what
            #
            # XXX THIS DOESN'T WORK WTF XXX
            #
            set clk [clock format [clock seconds] -format "%H"]
            if {$clk>=9 && $clk<=21} {
                ::AstMan::originate Zap g3 "1$ph" 100 shadydial 1 15000 $ph
            } else {
                puts $fd "!!! ERROR: TRIED TO CALL BEFORE OR AFTER 9 !!!"
            }
        }
        flush $fd
        close $fd
        if {$pace==""} {
            set pace 5000
        }
        set pace [expr {round(double($pace)/double($::AstMan::slimlogg))}]
        pg_disconnect $pgc
    }

    if {$pace==""} {
        set pace 5000
    }

    set fd [open /tmp/shadydial.log a]
    puts $fd "PACE: $pace"
    flush $fd
    close $fd

    ::AstMan::showagentqueues
    ::AstMan::showagentshort
    #::AstMan::showqueues
    #::AstMan::queuestatus
    #::AstMan::slimagents
    # keep us alive
    if { ![info exists ::AstMan::sock] } {
        set fd [open /tmp/shadydial.log a]
        puts $fd "RESTART NO SOCK: [clock format [clock seconds]]"
        close $fd
        after 10000 loginast
        gob
    }
    if { [eof $::AstMan::sock] } {
        close $::AstMan::sock
        unset $::AstMan::sock
        set fd [open /tmp/shadydial.log a]
        puts $fd "RESTART EOF SOCK: [clock format [clock seconds]]"
        close $fd
        after 10000 loginast
        gob
    }
    if {$::AstMan::emptybufflines == $::AstMan::ohmyebl} {
        ::AstMan::logoff
        if {$stallcnt>3} {
            set stallcnt 0
            set fd [open /tmp/shadydial.log a]
            puts $fd "STALLED: [clock format [clock seconds]]"
            close $fd
            exit
        } else {
            incr stallcnt
        }
        loginast
        gob
        set ::AstMan::calls [list]
        set ::AstMan::custconn 0
        set ::AstMan::slimtalk 0
#        ::AstMan::showagentqueues
#        ::AstMan::slimagents
        #after 10000 dispatcher
        after $pace dispatcher
    } else {
        set stallcnt 0
        set ::AstMan::ohmyebl $::AstMan::emptybufflines
#        ::AstMan::showagentqueues
#        ::AstMan::slimagents
        #after 2000 dispatcher
        after $pace dispatcher
    }
}


# this daemon code is take from the Tcl'ers Wiki at http://mini.net/tcl/2224
# by Tom Poindexter
proc daemonize {} {
    close stdin
    close stdout
    close stderr
    if {[fork]} {exit 0}
    id process group set
    if {[fork]} {exit 0}
    set fd [open /dev/null r]
    set fd [open /dev/null w]
    set fd [open /dev/null w]
    cd /
    umask 022
    return [id process]
}

proc gob {} {
    fileevent $::AstMan::sock readable {
        if {[gets $::AstMan::sock line] < 0} {return}
        #set line [gets $::AstMan::sock]
        ::AstMan::gobble $line
    }
}

proc loginast {} {
    set loginok [::AstMan::login $shady_ast_host $shady_ast_port $shady_ast_user $shady_ast_password]
    if {!$loginok} {
        set fd [open /tmp/shadydial.log a]
        puts $fd "COULD NOT LOG INTO $shady_ast_host: [clock format [clock seconds]]"
        close $fd
        shutdown
    }
}

global emptylines 0
global stallcnt 0
loginast
gob
daemonize
signal ignore  SIGHUP
signal unblock {QUIT TERM}
signal trap    {QUIT TERM} shutdown
after 1000 dispatcher
vwait done

