/* UDP client for testing the UDP test server */

/* For the UDP protocol entry */
#include <netdb.h>

/* For sockets */
#include <sys/types.h>
#include <sys/socket.h>

/* For INET sockets */
#include <netinet/in.h>
#include <arpa/inet.h>

/* Printing info about connections */
#include <stdio.h>
#include <unistd.h>

/* memcpy() */
#include <string.h>

#define TEST_UDP_PORT   6667

int main (int argc, char **argv) {
	struct protoent *udp_proto;
	int CONNECTSOCKET;
	struct sockaddr_in server_socket,client_socket;
	struct hostent *interface;
	char message[50] = "This is a test\n";

	/* Which interface do we want to use? */
	if (argc > 1)
		interface = gethostbyname(argv[1]);
	else {
		fprintf(stderr, "Usage: %s server_ip\n",argv[0]);
		exit(1);
	}

	udp_proto = getprotobyname("udp");
	CONNECTSOCKET = socket(PF_INET,SOCK_DGRAM,udp_proto->p_proto);

	if (interface) {
		server_socket.sin_family = AF_INET;
		memcpy((char *) &server_socket.sin_addr.s_addr,interface->h_addr_list[0],sizeof(interface->h_addr_list[0]));
		server_socket.sin_port = htons(TEST_UDP_PORT);
	} else {
		fprintf(stderr, "Interface %s was not found\n", argv[1]);
		exit(1);
	}

	client_socket.sin_family = AF_INET;
	client_socket.sin_addr.s_addr = htonl(INADDR_ANY);
	client_socket.sin_port = htons(0);

	bind(CONNECTSOCKET,(struct sockaddr *) &client_socket, sizeof(client_socket));

#if 0
	send(CONNECTSOCKET,message,strlen(message),MSG_EOF);
#else
	sendto(CONNECTSOCKET,message,strlen(message) + 1,0,(struct sockaddr *)&server_socket,sizeof(server_socket));
#endif
	close(CONNECTSOCKET);
	/* fputs("Connection closed\n",stdout); */

	return 0;
}

