#include <stdio.h>
#include <alloc.h>
#include <conio.h>

/*The node of the linked list consists of the data part (which is an integer)
  and the pointer to the next element "next".*/
typedef struct lis {
	int data;
	struct lis *next;} list;

/*Creating a type where elements of this type are pointers to the linked list*/
typedef list *plist;


/*The function add_to_end creates and adds a node at the end of the linked
  list, if the linked list does not exist, the function will create it.*/
void add_to_end(plist *h, int n)
{
 plist p, q;
 if (!*h)
	{
	 *h = (plist) malloc (sizeof (list));
	 (*h)->data = n;
	 (*h)->next = *h;
	}
 else
	{
	 p = *h;
	 while (p->next != *h)
		p = p->next;
	 q = (plist) malloc (sizeof (list));
	 q->data = n;
	 p->next = q;
	 q->next = *h;
	}
}


/*The function add_to_beginning creates and adds a node at the beginning of the
 linked list, if the linked list does not exist, the function will create it.*/
void add_to_beginning(plist *h, int n)
{
 plist p, q;
 p = (plist) malloc (sizeof (list));
 p->data = n;
 p->next = *h;
 q= *h;
 while (q->next != *h)
	q = q->next;
 q->next = p;
 *h = p;
}


/*The function search_list searches the linked list for the node containing
  the integer n, and returns this node if is found, NULL is returned
  otherwise*/
plist search_list(plist h, int n)
{
 plist p;
 if (h->data == n)
	return h;
 p = h->next;
 while (p != h)
 {
  if (p->data == n)
	return p;
  p = p->next;
 }
 return NULL;
}


/*The function add_before adds a node before a node x in the linked list
  *h. A special case is taken into consideration where x is equal to *h,
  the head of the linked list will then change*/
void add_before(plist *h, plist x, int n)
{
 plist p, temp, y, q;
 p = *h;
 temp = *h;
 if ((!*h) || (!x))
	return; //cannot do anything if x or *h are NULL
 q = *h;
 while (q->next != *h)
	q = q->next;
 y = (plist) malloc (sizeof (list));
 y->data = n;
 if (x == *h)
  {
	y->next = *h;
	*h = y;
	q->next = *h;
  }
 else
  {
	while (p != x)
		{
		 temp = p;
		 p = p->next;
		}
	if (p == x)
	{
	 y->next = x;
	 temp->next = y;
	}
  }
}


/*add_after adds a node (containing n as data), after the node x in the linked
  list *h */
void add_after(plist *h, plist x, int n)
{
 plist temp, y;
 temp = *h;
 if ((!*h) || (!x))
	return; //cannot do anything if x or *h are NULL
 y = (plist) malloc (sizeof (list));
 y->data = n;
 temp = x->next;
 x->next = y;
 y->next = temp; //works even if temp is NULL
}


/*delete_node deletes the node x (if it is found), in the linked list *h */
void delete_node(plist *h, plist x)
{
 plist p, temp, q;
 q = *h;
 while (q->next != *h)
	q = q->next;
 if (x == *h)
	{
	 temp = *h;
	 *h = (*h) ->next;
	 q->next = *h;
	 free (temp);
	 printf("Deletion succeeded\n");
	}
 else
	{
	 p = *h;
	 while (p)
	  {
		if (p->next == x)
			{
			 temp = x;
			 p->next = p->next->next;
			 free (temp);
			 printf("Deletion succeeded\n");
			 return;
			}
		else
			p = p->next;
		}
	 printf("Deletion did not succeed\n");
	 }
}

/*cuts a node for the linked list*/
plist cut_node(plist *h, plist x)
{
 plist p, temp, q;
 q = *h;
 while (q->next != *h)
	q = q->next;
 if (x == *h)
	{
	 temp = *h;
	 *h = (*h) ->next;
    q->next = *h;
	 return temp;
	}
 else
	{
	 p = *h;
	 while (p)
	  {
		if (p->next == x)
			{
			 temp = x;
			 p->next = p->next->next;
			 return temp;
			}
		else
			p = p->next;
		}
	  return NULL;
	 }
}


/*The function print_list prints the linked list starting from the head, until
  NULL is reached*/
void print_list(plist h)
{
 plist p;
 p = h;
 while (p->next != h)
	{
	 printf("%d -- ", p->data);
	 p = p->next;
	}
 printf("%d", p->data);
}


/*The menu function prints all the availalbe choices for the user to choose
  from, and calls all the above function, menu is called from main()
  with no parameters*/
void menu()
{
 plist head, t, cut;
 int i, number, number2;
 head = NULL;
 while (1)
 {
  clrscr();
  printf("Choose one of the following:\n");
  printf("1- Add a node at the end of the linked list\n");
  printf("2- Add a node at the beginning of the linked list\n");
  printf("3- Add a node after a certain node\n");
  printf("4- Add a node before a certain node\n");
  printf("5- Search for a node\n");
  printf("6- Delete a node\n");
  printf("7- Cut a node\n");
  printf("8- Print the linked list\n");
  printf("9- Exit the program\n");
  scanf("%d", &i);
  switch(i)
  {
	case 1: printf("Enter Number to add to end:");
			  scanf("%d", &number);
			  add_to_end(&head, number);
			  printf("Number added to end of list");
			  getch();
			  break;
	case 2: printf("Enter Number to add to beginning:");
			  scanf("%d", &number);
			  add_to_beginning(&head, number);
			  printf("Number added to beginning of list");
			  getch();
			  break;
	case 3: printf("Enter number of the node");
			  scanf("%d", &number);
			  t =  search_list(head, number);
			  if (t)
				{
				 printf("Enter number you want to add");
				 scanf("%d", &number2);
				 add_after(&head, t, number2);
				 printf("Number added to list");
				}
			  else
				printf("Search item is not found");
			  getch();
			  break;
	case 4: printf("Enter number of the node");
			  scanf("%d", &number);
			  t =  search_list(head, number);
			  if (t)
				{
				 printf("Enter number you want to add");
				 scanf("%d", &number2);
				 add_before(&head, t, number2);
				 printf("Number added to list");
				}
			  else
				printf("Search item is not found");
			  getch();
			  break;
	case 5: printf("Enter number of the node");
			  scanf("%d", &number);
			  t =  search_list(head, number);
			  if (t)
				printf("Search succeeded: Item found");
			  else
				printf("Search failed: Item not found");
			  getch();
			  break;
	case 6: printf("Enter number of node you want to delete");
			  scanf("%d", &number);
			  t= search_list(head, number);
			  if (t)
				  delete_node(&head, t);
			  getch();
			  break;
	case 7: printf("Enter number of node you want to cut");
			  scanf("%d", &number);
			  t = search_list(head, number);
			  if (t)
				  cut = cut_node(&head, t);
			  if (cut)
				printf("Element is cut from list");
			  else
				printf("Operation failed: Element is not found in list");
			  getch();
			  break;
	case 8: print_list(head);
			  getch();
			  break;
	case 9: printf("Bye"); getch();
			  return;
	default:printf("Illegal choice"); getch();
	}
 }
}






main()
{
 menu();
 return 0;
}




