#include <stdio.h>
#include <alloc.h>
#include <conio.h>

/*The node of the double linked list consists of the data part (which is
  an integer) and the pointer to the next element "next".*/
typedef struct lis {
	int data;
	struct lis *next, *previous;} dlist;

/*Creating a type where elements of this type are pointers to the
  double linked list*/
typedef dlist *pdlist;


/*The function add_to_end creates and adds a node at the end of the double
  linked list, if the linked list does not exist, the function will create it.*/
void add_to_end(pdlist *h, int n)
{
 pdlist p;
 if (!*h)
	{
	 *h = (pdlist) malloc (sizeof (dlist));
	 (*h)->data = n;
	 (*h)->next = NULL;
	 (*h)->previous = NULL;
	}
 else
	{
	 p = *h;
	 while (p->next)
		p = p->next;
	 p->next = (pdlist) malloc (sizeof (dlist));
	 p = p->next;
	 p->data = n;
	 p->next = NULL;
	 p->previous = *h;
	}
}


/*The function add_to_beginning creates and adds a node at the beginning of the
  double linked list, if the linked list does not exist, the function will
  create it.*/
void add_to_beginning(pdlist *h, int n)
{
 pdlist p;
 p = (pdlist) malloc (sizeof (dlist));
 p->data = n;
 p->next = *h;
 (*h)->previous = p;
 p->previous = NULL;
 *h = p;
}


/*The function search_list searches the double linked list for the node
  containing the integer n, and returns this node if is found, NULL is returned
  otherwise*/
pdlist search_list(pdlist h, int n)
{
 pdlist p;
 p = h;
 while (p)
 {
  if (p->data == n)
	return p;
  p = p->next;
 }
 return NULL;
}


/*The function add_before adds a node before a node x in the double linked list
  *h. A special case is taken into consideration where x is equal to *h,
  the head of the double linked list will then change*/
void add_before(pdlist *h, pdlist x, int n)
{
 pdlist y;
 y = (pdlist) malloc (sizeof (dlist));
 y->data = n;
 if (x== *h)
	{
	 (*h)->previous = y;
	 y->previous = NULL;
	 y->next = *h;
	 *h = y;
	}
 else
	{
	 y->previous = x->previous;
	 y->next = x;
	 x->previous->next = y;
	 x->previous = y;
	}
}


/*add_after adds a node (containing n as data), after the node x in the double
  linked list *h */
void add_after(pdlist *h, pdlist x, int n)
{
 pdlist y;
 y = (pdlist) malloc (sizeof (dlist));
 y->data = n;
 if (x->next  == NULL)
	{
	 x->next = y;
	 y->next = NULL;
	 y->previous = x;
	}
 else
	{
	 y->previous = x;
	 y->next = x->next;
	 x->next->previous = y;
	 x->next = y;
	}
}


/*delete_node deletes the node x (if it is found), in the double
  linked list *h */
void delete_node(pdlist *h, pdlist x)
{
 pdlist temp;
 if (*h == x)
	{
	 if (!(*h)->next)
		{
		 free(*h);
		 *h = NULL;
		}
	 else
		{
		 temp = *h;
		 *h = (*h)->next;
		 free (temp);
		 (*h)->previous = NULL;
		}
	 return;
	}
 x->previous->next = x->next;
 if (x->next)
	{
	 x->next->previous = x->previous;
	}
 free(x);
}


/*cuts (deletes without freeing) node x from the linked list*/
pdlist cut_node(pdlist *h, pdlist x)
{
 pdlist temp;
 temp = (pdlist) malloc (sizeof (dlist));
 temp->data = x->data;
 if (*h == x)
	{
	 *h = (*h)->next;
	 (*h)->previous = NULL;
	 return temp;
	}
 x->previous->next = x->next;
 if (x->next)
	{
	 x->next->previous = x->previous;
	}
 return temp;
}


/*The function print_list prints the double linked list starting from the
  head, until NULL is reached*/
void print_list(pdlist h)
{
 pdlist p;
 p = h;
 while (p != NULL)
	{
	 printf("%d -- ", p->data);
	 p = p->next;
	}
}


/*The menu function prints all the availalbe choices for the user to choose
  from, and calls all the above function, menu is called from main()
  with no parameters*/
void menu()
{
 pdlist head, t, cut;
 int i, number, number2;
 head = NULL;
 while (1)
 {
  clrscr();
  printf("Choose one of the following:\n");
  printf("1- Add a node at the end of the linked list\n");
  printf("2- Add a node at the beginning of the linked list\n");
  printf("3- Add a node after a certain node\n");
  printf("4- Add a node before a certain node\n");
  printf("5- Search for a node\n");
  printf("6- Delete a node\n");
  printf("7- Cut a node\n");
  printf("8- Print the linked list\n");
  printf("9- Exit the program\n");
  scanf("%d", &i);
  switch(i)
  {
	case 1: printf("Enter Number to add to end:");
			  scanf("%d", &number);
			  add_to_end(&head, number);
			  printf("Number added to end of list");
			  getch();
			  break;
	case 2: printf("Enter Number to add to beginning:");
			  scanf("%d", &number);
			  add_to_beginning(&head, number);
			  printf("Number added to beginning of list");
			  getch();
			  break;
	case 3: printf("Enter number of the node");
			  scanf("%d", &number);
			  t =  search_list(head, number);
			  if (t)
				{
				 printf("Enter number you want to add");
				 scanf("%d", &number2);
				 add_after(&head, t, number2);
				 printf("Number added to list");
				}
			  else
				printf("Search item is not found");
			  getch();
			  break;
	case 4: printf("Enter number of the node");
			  scanf("%d", &number);
			  t =  search_list(head, number);
			  if (t)
				{
				 printf("Enter number you want to add");
				 scanf("%d", &number2);
				 add_before(&head, t, number2);
				 printf("Number added to list");
				}
			  else
				printf("Search item is not found");
			  getch();
			  break;
	case 5: printf("Enter number of the node");
			  scanf("%d", &number);
			  t =  search_list(head, number);
			  if (t)
				printf("Search succeeded: Item found");
			  else
				printf("Search failed: Item not found");
			  getch();
			  break;
	case 6: printf("Enter number of node you want to delete");
			  scanf("%d", &number);
			  t= search_list(head, number);
			  if (t)
			  {
				delete_node(&head, t);
				printf("Deletion succeeded\n");
			  }
			  else
				printf("Delete Item not found");
			  getch();
			  break;
	case 7: printf("Enter number of node you want to cut");
			  scanf("%d", &number);
			  t = search_list(head, number);
			  cut = cut_node(&head, t);
			  if (cut)
				printf("Element is cut from list");
			  else
				printf("Operation failed: Element is not found in list");
			  getch();
			  break;
	case 8: print_list(head);
			  getch();
			  break;
	case 9: printf("Bye"); getch();
			  return;
	default:printf("Illegal choice"); getch();
	}
 }
}






main()
{
 menu();
 return 0;
}




