#include <stdio.h>
#include <alloc.h>
#include <conio.h>


/*The structure of the linked list to be used in the queue*/
typedef struct lis
	{
	 int data;
	 struct lis *next;
	} list;

/*creating a pointer to the linked list*/
typedef list *plist;

/*The structure of the queue consists of 2 pointers, t, and q*/
typedef struct list_Q
	{
	 plist t, q;
	} lq;

/*Init_lq will initialize the pointers of the structure to NULL*/
void Init_lq(lq *l)
	{
	 l->t = NULL;
	 l->q = NULL;
	}

/*push_lq pushes a number at the tail of the queue, all extreme cases are
  handled. Returns 0 if pushing can't be done (cannot malloc), 1 if
  pushing is successful*/
int push_lq(lq *l, int i)
	{
	 plist n;
	 n = (plist) malloc (sizeof (list));
	 n->data = i;
	 n->next = l->t;
	 l->t = n;
	 if (l->q == NULL)
		l->q = l->t;
	 return 1;
	}

/*pop_lq pops the head of the queue, all extreme cases are handled. Returns
  t when popping is successful, 0 if it is not*/
int pop_lq(lq *l, int *extracted)
{
 plist aux;
 if (l->q == NULL)
	return 0;
 *extracted = (l->q)->data;
 if (l->t == l->q)
 {
  l->t = NULL;
  free (l->q);
  l->q = NULL;
  return 1;
 }
 aux = l->t;
 while (aux -> next != l->q)
	aux = aux->next;
 free(l->q);
 aux->next = NULL;
 l->q = aux;
 return 1;
}


/*menu presents the user with the choices to push to the queue, or pop from
 the queue, queue is intialized automatically at the beginning of the
 function*/
void menu()
{
 lq ql;
 char c;
 int i;
 Init_lq(&ql);
 while (1)
 {
  clrscr();
  printf("\nChoose an option:");
  printf("\na- Push a number to    the queue");
  printf("\nb- Pop  a number from  the queue");
  printf("\nc- Exit the program");
  printf("\nYour choice:");
  c=getch();
  switch(c)
  {
	  case 'a': printf("\nEnter number:");scanf("%d", &i);
					if (push_lq(&ql, i))
						printf("Operation successful!");
					else
						printf("No more memory!");
					getch();
					break;
	  case 'b': if (pop_lq(&ql, &i))
						printf("\nPopped element is: %d", i);
					else
						printf("\nQueue is empty");
					getch();
					break;
	  case 'c': printf("Bye");getch();return;
  }
 }
}

main()
{
 menu();
 return 0;
}

